package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayCategories invokes the sgw.DescribeGatewayCategories API synchronously
func (client *Client) DescribeGatewayCategories(request *DescribeGatewayCategoriesRequest) (response *DescribeGatewayCategoriesResponse, err error) {
	response = CreateDescribeGatewayCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayCategoriesWithChan invokes the sgw.DescribeGatewayCategories API asynchronously
func (client *Client) DescribeGatewayCategoriesWithChan(request *DescribeGatewayCategoriesRequest) (<-chan *DescribeGatewayCategoriesResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayCategoriesWithCallback invokes the sgw.DescribeGatewayCategories API asynchronously
func (client *Client) DescribeGatewayCategoriesWithCallback(request *DescribeGatewayCategoriesRequest, callback func(response *DescribeGatewayCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayCategoriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayCategoriesRequest is the request struct for api DescribeGatewayCategories
type DescribeGatewayCategoriesRequest struct {
	*requests.RpcRequest
	GatewayLocation string `position:"Query" name:"GatewayLocation"`
	SecurityToken   string `position:"Query" name:"SecurityToken"`
}

// DescribeGatewayCategoriesResponse is the response struct for api DescribeGatewayCategories
type DescribeGatewayCategoriesResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Success    bool   `json:"Success" xml:"Success"`
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	Categories string `json:"Categories" xml:"Categories"`
}

// CreateDescribeGatewayCategoriesRequest creates a request to invoke DescribeGatewayCategories API
func CreateDescribeGatewayCategoriesRequest() (request *DescribeGatewayCategoriesRequest) {
	request = &DescribeGatewayCategoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayCategories", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayCategoriesResponse creates a response to parse from DescribeGatewayCategories response
func CreateDescribeGatewayCategoriesResponse() (response *DescribeGatewayCategoriesResponse) {
	response = &DescribeGatewayCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
