package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCustomImages invokes the swas_open.ListCustomImages API synchronously
func (client *Client) ListCustomImages(request *ListCustomImagesRequest) (response *ListCustomImagesResponse, err error) {
	response = CreateListCustomImagesResponse()
	err = client.DoAction(request, response)
	return
}

// ListCustomImagesWithChan invokes the swas_open.ListCustomImages API asynchronously
func (client *Client) ListCustomImagesWithChan(request *ListCustomImagesRequest) (<-chan *ListCustomImagesResponse, <-chan error) {
	responseChan := make(chan *ListCustomImagesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCustomImages(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCustomImagesWithCallback invokes the swas_open.ListCustomImages API asynchronously
func (client *Client) ListCustomImagesWithCallback(request *ListCustomImagesRequest, callback func(response *ListCustomImagesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCustomImagesResponse
		var err error
		defer close(result)
		response, err = client.ListCustomImages(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCustomImagesRequest is the request struct for api ListCustomImages
type ListCustomImagesRequest struct {
	*requests.RpcRequest
	SystemSnapshotId string                 `position:"Query" name:"SystemSnapshotId"`
	DataSnapshotId   string                 `position:"Query" name:"DataSnapshotId"`
	ClientToken      string                 `position:"Query" name:"ClientToken"`
	ImageNames       string                 `position:"Query" name:"ImageNames"`
	PageNumber       requests.Integer       `position:"Query" name:"PageNumber"`
	ResourceGroupId  string                 `position:"Query" name:"ResourceGroupId"`
	PageSize         requests.Integer       `position:"Query" name:"PageSize"`
	Share            requests.Boolean       `position:"Query" name:"Share"`
	Tag              *[]ListCustomImagesTag `position:"Query" name:"Tag"  type:"Repeated"`
	InstanceId       string                 `position:"Query" name:"InstanceId"`
	ImageIds         string                 `position:"Query" name:"ImageIds"`
}

// ListCustomImagesTag is a repeated param struct in ListCustomImagesRequest
type ListCustomImagesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListCustomImagesResponse is the response struct for api ListCustomImages
type ListCustomImagesResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	TotalCount   string        `json:"TotalCount" xml:"TotalCount"`
	PageSize     string        `json:"PageSize" xml:"PageSize"`
	PageNumber   string        `json:"PageNumber" xml:"PageNumber"`
	CustomImages []CustomImage `json:"CustomImages" xml:"CustomImages"`
}

// CreateListCustomImagesRequest creates a request to invoke ListCustomImages API
func CreateListCustomImagesRequest() (request *ListCustomImagesRequest) {
	request = &ListCustomImagesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ListCustomImages", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListCustomImagesResponse creates a response to parse from ListCustomImages response
func CreateListCustomImagesResponse() (response *ListCustomImagesResponse) {
	response = &ListCustomImagesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
