package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySlotTemplate invokes the unimkt.ModifySlotTemplate API synchronously
func (client *Client) ModifySlotTemplate(request *ModifySlotTemplateRequest) (response *ModifySlotTemplateResponse, err error) {
	response = CreateModifySlotTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySlotTemplateWithChan invokes the unimkt.ModifySlotTemplate API asynchronously
func (client *Client) ModifySlotTemplateWithChan(request *ModifySlotTemplateRequest) (<-chan *ModifySlotTemplateResponse, <-chan error) {
	responseChan := make(chan *ModifySlotTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySlotTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySlotTemplateWithCallback invokes the unimkt.ModifySlotTemplate API asynchronously
func (client *Client) ModifySlotTemplateWithCallback(request *ModifySlotTemplateRequest, callback func(response *ModifySlotTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySlotTemplateResponse
		var err error
		defer close(result)
		response, err = client.ModifySlotTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySlotTemplateRequest is the request struct for api ModifySlotTemplate
type ModifySlotTemplateRequest struct {
	*requests.RpcRequest
	Business         string `position:"Query" name:"Business"`
	ClientToken      string `position:"Query" name:"ClientToken"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	AdSlotTemplate   string `position:"Body" name:"AdSlotTemplate"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	UserSite         string `position:"Query" name:"UserSite"`
}

// ModifySlotTemplateResponse is the response struct for api ModifySlotTemplate
type ModifySlotTemplateResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateModifySlotTemplateRequest creates a request to invoke ModifySlotTemplate API
func CreateModifySlotTemplateRequest() (request *ModifySlotTemplateRequest) {
	request = &ModifySlotTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "ModifySlotTemplate", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySlotTemplateResponse creates a response to parse from ModifySlotTemplate response
func CreateModifySlotTemplateResponse() (response *ModifySlotTemplateResponse) {
	response = &ModifySlotTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
