package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainHitRateData invokes the vod.DescribeVodDomainHitRateData API synchronously
func (client *Client) DescribeVodDomainHitRateData(request *DescribeVodDomainHitRateDataRequest) (response *DescribeVodDomainHitRateDataResponse, err error) {
	response = CreateDescribeVodDomainHitRateDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainHitRateDataWithChan invokes the vod.DescribeVodDomainHitRateData API asynchronously
func (client *Client) DescribeVodDomainHitRateDataWithChan(request *DescribeVodDomainHitRateDataRequest) (<-chan *DescribeVodDomainHitRateDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainHitRateDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainHitRateData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainHitRateDataWithCallback invokes the vod.DescribeVodDomainHitRateData API asynchronously
func (client *Client) DescribeVodDomainHitRateDataWithCallback(request *DescribeVodDomainHitRateDataRequest, callback func(response *DescribeVodDomainHitRateDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainHitRateDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainHitRateData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainHitRateDataRequest is the request struct for api DescribeVodDomainHitRateData
type DescribeVodDomainHitRateDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeVodDomainHitRateDataResponse is the response struct for api DescribeVodDomainHitRateData
type DescribeVodDomainHitRateDataResponse struct {
	*responses.BaseResponse
	EndTime         string          `json:"EndTime" xml:"EndTime"`
	StartTime       string          `json:"StartTime" xml:"StartTime"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	DomainName      string          `json:"DomainName" xml:"DomainName"`
	DataInterval    string          `json:"DataInterval" xml:"DataInterval"`
	HitRateInterval HitRateInterval `json:"HitRateInterval" xml:"HitRateInterval"`
}

// CreateDescribeVodDomainHitRateDataRequest creates a request to invoke DescribeVodDomainHitRateData API
func CreateDescribeVodDomainHitRateDataRequest() (request *DescribeVodDomainHitRateDataRequest) {
	request = &DescribeVodDomainHitRateDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainHitRateData", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVodDomainHitRateDataResponse creates a response to parse from DescribeVodDomainHitRateData response
func CreateDescribeVodDomainHitRateDataResponse() (response *DescribeVodDomainHitRateDataResponse) {
	response = &DescribeVodDomainHitRateDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
