package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExpressConnectTrafficQosRule invokes the vpc.DeleteExpressConnectTrafficQosRule API synchronously
func (client *Client) DeleteExpressConnectTrafficQosRule(request *DeleteExpressConnectTrafficQosRuleRequest) (response *DeleteExpressConnectTrafficQosRuleResponse, err error) {
	response = CreateDeleteExpressConnectTrafficQosRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExpressConnectTrafficQosRuleWithChan invokes the vpc.DeleteExpressConnectTrafficQosRule API asynchronously
func (client *Client) DeleteExpressConnectTrafficQosRuleWithChan(request *DeleteExpressConnectTrafficQosRuleRequest) (<-chan *DeleteExpressConnectTrafficQosRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteExpressConnectTrafficQosRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExpressConnectTrafficQosRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExpressConnectTrafficQosRuleWithCallback invokes the vpc.DeleteExpressConnectTrafficQosRule API asynchronously
func (client *Client) DeleteExpressConnectTrafficQosRuleWithCallback(request *DeleteExpressConnectTrafficQosRuleRequest, callback func(response *DeleteExpressConnectTrafficQosRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExpressConnectTrafficQosRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteExpressConnectTrafficQosRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExpressConnectTrafficQosRuleRequest is the request struct for api DeleteExpressConnectTrafficQosRule
type DeleteExpressConnectTrafficQosRuleRequest struct {
	*requests.RpcRequest
	ClientToken          string           `position:"Query" name:"ClientToken"`
	QosId                string           `position:"Query" name:"QosId"`
	QueueId              string           `position:"Query" name:"QueueId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RuleId               string           `position:"Query" name:"RuleId"`
}

// DeleteExpressConnectTrafficQosRuleResponse is the response struct for api DeleteExpressConnectTrafficQosRule
type DeleteExpressConnectTrafficQosRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteExpressConnectTrafficQosRuleRequest creates a request to invoke DeleteExpressConnectTrafficQosRule API
func CreateDeleteExpressConnectTrafficQosRuleRequest() (request *DeleteExpressConnectTrafficQosRuleRequest) {
	request = &DeleteExpressConnectTrafficQosRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteExpressConnectTrafficQosRule", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteExpressConnectTrafficQosRuleResponse creates a response to parse from DeleteExpressConnectTrafficQosRule response
func CreateDeleteExpressConnectTrafficQosRuleResponse() (response *DeleteExpressConnectTrafficQosRuleResponse) {
	response = &DeleteExpressConnectTrafficQosRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
