package aimath

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GlobalConfirm invokes the aimath.GlobalConfirm API synchronously
func (client *Client) GlobalConfirm(request *GlobalConfirmRequest) (response *GlobalConfirmResponse, err error) {
	response = CreateGlobalConfirmResponse()
	err = client.DoAction(request, response)
	return
}

// GlobalConfirmWithChan invokes the aimath.GlobalConfirm API asynchronously
func (client *Client) GlobalConfirmWithChan(request *GlobalConfirmRequest) (<-chan *GlobalConfirmResponse, <-chan error) {
	responseChan := make(chan *GlobalConfirmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GlobalConfirm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GlobalConfirmWithCallback invokes the aimath.GlobalConfirm API asynchronously
func (client *Client) GlobalConfirmWithCallback(request *GlobalConfirmRequest, callback func(response *GlobalConfirmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GlobalConfirmResponse
		var err error
		defer close(result)
		response, err = client.GlobalConfirm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GlobalConfirmRequest is the request struct for api GlobalConfirm
type GlobalConfirmRequest struct {
	*requests.RpcRequest
	Tag          string `position:"Body" name:"Tag"`
	ExerciseCode string `position:"Body" name:"ExerciseCode"`
}

// GlobalConfirmResponse is the response struct for api GlobalConfirm
type GlobalConfirmResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrCode   string `json:"ErrCode" xml:"ErrCode"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
}

// CreateGlobalConfirmRequest creates a request to invoke GlobalConfirm API
func CreateGlobalConfirmRequest() (request *GlobalConfirmRequest) {
	request = &GlobalConfirmRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AIMath", "2024-11-14", "GlobalConfirm", "", "")
	request.Method = requests.POST
	return
}

// CreateGlobalConfirmResponse creates a response to parse from GlobalConfirm response
func CreateGlobalConfirmResponse() (response *GlobalConfirmResponse) {
	response = &GlobalConfirmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
