package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDnsGtmAddressPool invokes the alidns.AddDnsGtmAddressPool API synchronously
func (client *Client) AddDnsGtmAddressPool(request *AddDnsGtmAddressPoolRequest) (response *AddDnsGtmAddressPoolResponse, err error) {
	response = CreateAddDnsGtmAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// AddDnsGtmAddressPoolWithChan invokes the alidns.AddDnsGtmAddressPool API asynchronously
func (client *Client) AddDnsGtmAddressPoolWithChan(request *AddDnsGtmAddressPoolRequest) (<-chan *AddDnsGtmAddressPoolResponse, <-chan error) {
	responseChan := make(chan *AddDnsGtmAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDnsGtmAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDnsGtmAddressPoolWithCallback invokes the alidns.AddDnsGtmAddressPool API asynchronously
func (client *Client) AddDnsGtmAddressPoolWithCallback(request *AddDnsGtmAddressPoolRequest, callback func(response *AddDnsGtmAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDnsGtmAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.AddDnsGtmAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDnsGtmAddressPoolRequest is the request struct for api AddDnsGtmAddressPool
type AddDnsGtmAddressPoolRequest struct {
	*requests.RpcRequest
	MonitorExtendInfo string                             `position:"Query" name:"MonitorExtendInfo"`
	LbaStrategy       string                             `position:"Query" name:"LbaStrategy"`
	Type              string                             `position:"Query" name:"Type"`
	Timeout           requests.Integer                   `position:"Query" name:"Timeout"`
	EvaluationCount   requests.Integer                   `position:"Query" name:"EvaluationCount"`
	Lang              string                             `position:"Query" name:"Lang"`
	Addr              *[]AddDnsGtmAddressPoolAddr        `position:"Query" name:"Addr"  type:"Repeated"`
	MonitorStatus     string                             `position:"Query" name:"MonitorStatus"`
	InstanceId        string                             `position:"Query" name:"InstanceId"`
	UserClientIp      string                             `position:"Query" name:"UserClientIp"`
	Name              string                             `position:"Query" name:"Name"`
	ProtocolType      string                             `position:"Query" name:"ProtocolType"`
	Interval          requests.Integer                   `position:"Query" name:"Interval"`
	IspCityNode       *[]AddDnsGtmAddressPoolIspCityNode `position:"Query" name:"IspCityNode"  type:"Repeated"`
}

// AddDnsGtmAddressPoolAddr is a repeated param struct in AddDnsGtmAddressPoolRequest
type AddDnsGtmAddressPoolAddr struct {
	AttributeInfo string `name:"AttributeInfo"`
	Mode          string `name:"Mode"`
	Remark        string `name:"Remark"`
	LbaWeight     string `name:"LbaWeight"`
	Addr          string `name:"Addr"`
}

// AddDnsGtmAddressPoolIspCityNode is a repeated param struct in AddDnsGtmAddressPoolRequest
type AddDnsGtmAddressPoolIspCityNode struct {
	CityCode string `name:"CityCode"`
	IspCode  string `name:"IspCode"`
}

// AddDnsGtmAddressPoolResponse is the response struct for api AddDnsGtmAddressPool
type AddDnsGtmAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	AddrPoolId      string `json:"AddrPoolId" xml:"AddrPoolId"`
	MonitorConfigId string `json:"MonitorConfigId" xml:"MonitorConfigId"`
}

// CreateAddDnsGtmAddressPoolRequest creates a request to invoke AddDnsGtmAddressPool API
func CreateAddDnsGtmAddressPoolRequest() (request *AddDnsGtmAddressPoolRequest) {
	request = &AddDnsGtmAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "AddDnsGtmAddressPool", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDnsGtmAddressPoolResponse creates a response to parse from AddDnsGtmAddressPool response
func CreateAddDnsGtmAddressPoolResponse() (response *AddDnsGtmAddressPoolResponse) {
	response = &AddDnsGtmAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
