package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetKeywordChEcom invokes the alinlp.GetKeywordChEcom API synchronously
func (client *Client) GetKeywordChEcom(request *GetKeywordChEcomRequest) (response *GetKeywordChEcomResponse, err error) {
	response = CreateGetKeywordChEcomResponse()
	err = client.DoAction(request, response)
	return
}

// GetKeywordChEcomWithChan invokes the alinlp.GetKeywordChEcom API asynchronously
func (client *Client) GetKeywordChEcomWithChan(request *GetKeywordChEcomRequest) (<-chan *GetKeywordChEcomResponse, <-chan error) {
	responseChan := make(chan *GetKeywordChEcomResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetKeywordChEcom(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetKeywordChEcomWithCallback invokes the alinlp.GetKeywordChEcom API asynchronously
func (client *Client) GetKeywordChEcomWithCallback(request *GetKeywordChEcomRequest, callback func(response *GetKeywordChEcomResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetKeywordChEcomResponse
		var err error
		defer close(result)
		response, err = client.GetKeywordChEcom(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetKeywordChEcomRequest is the request struct for api GetKeywordChEcom
type GetKeywordChEcomRequest struct {
	*requests.RpcRequest
	ApiVersion  string `position:"Body" name:"ApiVersion"`
	ServiceCode string `position:"Body" name:"ServiceCode"`
	Text        string `position:"Body" name:"Text"`
}

// GetKeywordChEcomResponse is the response struct for api GetKeywordChEcom
type GetKeywordChEcomResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetKeywordChEcomRequest creates a request to invoke GetKeywordChEcom API
func CreateGetKeywordChEcomRequest() (request *GetKeywordChEcomRequest) {
	request = &GetKeywordChEcomRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetKeywordChEcom", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetKeywordChEcomResponse creates a response to parse from GetKeywordChEcom response
func CreateGetKeywordChEcomResponse() (response *GetKeywordChEcomResponse) {
	response = &GetKeywordChEcomResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
