package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStack invokes the arms.GetStack API synchronously
func (client *Client) GetStack(request *GetStackRequest) (response *GetStackResponse, err error) {
	response = CreateGetStackResponse()
	err = client.DoAction(request, response)
	return
}

// GetStackWithChan invokes the arms.GetStack API asynchronously
func (client *Client) GetStackWithChan(request *GetStackRequest) (<-chan *GetStackResponse, <-chan error) {
	responseChan := make(chan *GetStackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStackWithCallback invokes the arms.GetStack API asynchronously
func (client *Client) GetStackWithCallback(request *GetStackRequest, callback func(response *GetStackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStackResponse
		var err error
		defer close(result)
		response, err = client.GetStack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStackRequest is the request struct for api GetStack
type GetStackRequest struct {
	*requests.RpcRequest
	TraceID   string           `position:"Query" name:"TraceID"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	RpcID     string           `position:"Query" name:"RpcID"`
	Pid       string           `position:"Query" name:"Pid"`
	StartTime requests.Integer `position:"Query" name:"StartTime"`
}

// GetStackResponse is the response struct for api GetStack
type GetStackResponse struct {
	*responses.BaseResponse
	RequestId string          `json:"RequestId" xml:"RequestId"`
	StackInfo []StackInfoItem `json:"StackInfo" xml:"StackInfo"`
}

// CreateGetStackRequest creates a request to invoke GetStack API
func CreateGetStackRequest() (request *GetStackRequest) {
	request = &GetStackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetStack", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStackResponse creates a response to parse from GetStack response
func CreateGetStackResponse() (response *GetStackResponse) {
	response = &GetStackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
