package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAvatar invokes the avatar.DeleteAvatar API synchronously
func (client *Client) DeleteAvatar(request *DeleteAvatarRequest) (response *DeleteAvatarResponse, err error) {
	response = CreateDeleteAvatarResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAvatarWithChan invokes the avatar.DeleteAvatar API asynchronously
func (client *Client) DeleteAvatarWithChan(request *DeleteAvatarRequest) (<-chan *DeleteAvatarResponse, <-chan error) {
	responseChan := make(chan *DeleteAvatarResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAvatar(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAvatarWithCallback invokes the avatar.DeleteAvatar API asynchronously
func (client *Client) DeleteAvatarWithCallback(request *DeleteAvatarRequest, callback func(response *DeleteAvatarResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAvatarResponse
		var err error
		defer close(result)
		response, err = client.DeleteAvatar(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAvatarRequest is the request struct for api DeleteAvatar
type DeleteAvatarRequest struct {
	*requests.RpcRequest
	Code         string           `position:"Query" name:"Code"`
	TenantId     requests.Integer `position:"Query" name:"TenantId"`
	ExtParamsCLS string           `position:"Query" name:"ExtParams_CLS"`
	ExtParams    string           `position:"Query" name:"ExtParams"`
}

// DeleteAvatarResponse is the response struct for api DeleteAvatar
type DeleteAvatarResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteAvatarRequest creates a request to invoke DeleteAvatar API
func CreateDeleteAvatarRequest() (request *DeleteAvatarRequest) {
	request = &DeleteAvatarRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "DeleteAvatar", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAvatarResponse creates a response to parse from DeleteAvatar response
func CreateDeleteAvatarResponse() (response *DeleteAvatarResponse) {
	response = &DeleteAvatarResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
