package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Sign invokes the cas.Sign API synchronously
func (client *Client) Sign(request *SignRequest) (response *SignResponse, err error) {
	response = CreateSignResponse()
	err = client.DoAction(request, response)
	return
}

// SignWithChan invokes the cas.Sign API asynchronously
func (client *Client) SignWithChan(request *SignRequest) (<-chan *SignResponse, <-chan error) {
	responseChan := make(chan *SignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Sign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SignWithCallback invokes the cas.Sign API asynchronously
func (client *Client) SignWithCallback(request *SignRequest, callback func(response *SignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SignResponse
		var err error
		defer close(result)
		response, err = client.Sign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SignRequest is the request struct for api Sign
type SignRequest struct {
	*requests.RpcRequest
	MessageType      string `position:"Query" name:"MessageType"`
	SigningAlgorithm string `position:"Query" name:"SigningAlgorithm"`
	Message          string `position:"Query" name:"Message"`
	SourceIp         string `position:"Query" name:"SourceIp"`
	CertIdentifier   string `position:"Query" name:"CertIdentifier"`
}

// SignResponse is the response struct for api Sign
type SignResponse struct {
	*responses.BaseResponse
	Signature string `json:"Signature" xml:"Signature"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSignRequest creates a request to invoke Sign API
func CreateSignRequest() (request *SignRequest) {
	request = &SignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "Sign", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSignResponse creates a response to parse from Sign response
func CreateSignResponse() (response *SignResponse) {
	response = &SignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
