package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCenRegionDomainRouteEntries invokes the cbn.DescribeCenRegionDomainRouteEntries API synchronously
func (client *Client) DescribeCenRegionDomainRouteEntries(request *DescribeCenRegionDomainRouteEntriesRequest) (response *DescribeCenRegionDomainRouteEntriesResponse, err error) {
	response = CreateDescribeCenRegionDomainRouteEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCenRegionDomainRouteEntriesWithChan invokes the cbn.DescribeCenRegionDomainRouteEntries API asynchronously
func (client *Client) DescribeCenRegionDomainRouteEntriesWithChan(request *DescribeCenRegionDomainRouteEntriesRequest) (<-chan *DescribeCenRegionDomainRouteEntriesResponse, <-chan error) {
	responseChan := make(chan *DescribeCenRegionDomainRouteEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCenRegionDomainRouteEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCenRegionDomainRouteEntriesWithCallback invokes the cbn.DescribeCenRegionDomainRouteEntries API asynchronously
func (client *Client) DescribeCenRegionDomainRouteEntriesWithCallback(request *DescribeCenRegionDomainRouteEntriesRequest, callback func(response *DescribeCenRegionDomainRouteEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCenRegionDomainRouteEntriesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCenRegionDomainRouteEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCenRegionDomainRouteEntriesRequest is the request struct for api DescribeCenRegionDomainRouteEntries
type DescribeCenRegionDomainRouteEntriesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CenId                string           `position:"Query" name:"CenId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DestinationCidrBlock string           `position:"Query" name:"DestinationCidrBlock"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
	CenRegionId          string           `position:"Query" name:"CenRegionId"`
	Status               string           `position:"Query" name:"Status"`
}

// DescribeCenRegionDomainRouteEntriesResponse is the response struct for api DescribeCenRegionDomainRouteEntries
type DescribeCenRegionDomainRouteEntriesResponse struct {
	*responses.BaseResponse
	PageSize        int                                                  `json:"PageSize" xml:"PageSize"`
	RequestId       string                                               `json:"RequestId" xml:"RequestId"`
	PageNumber      int                                                  `json:"PageNumber" xml:"PageNumber"`
	TotalCount      int                                                  `json:"TotalCount" xml:"TotalCount"`
	CenRouteEntries CenRouteEntriesInDescribeCenRegionDomainRouteEntries `json:"CenRouteEntries" xml:"CenRouteEntries"`
}

// CreateDescribeCenRegionDomainRouteEntriesRequest creates a request to invoke DescribeCenRegionDomainRouteEntries API
func CreateDescribeCenRegionDomainRouteEntriesRequest() (request *DescribeCenRegionDomainRouteEntriesRequest) {
	request = &DescribeCenRegionDomainRouteEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeCenRegionDomainRouteEntries", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCenRegionDomainRouteEntriesResponse creates a response to parse from DescribeCenRegionDomainRouteEntries response
func CreateDescribeCenRegionDomainRouteEntriesResponse() (response *DescribeCenRegionDomainRouteEntriesResponse) {
	response = &DescribeCenRegionDomainRouteEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
