package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddWirelessCloudConnectorToGroup invokes the cc5g.AddWirelessCloudConnectorToGroup API synchronously
func (client *Client) AddWirelessCloudConnectorToGroup(request *AddWirelessCloudConnectorToGroupRequest) (response *AddWirelessCloudConnectorToGroupResponse, err error) {
	response = CreateAddWirelessCloudConnectorToGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddWirelessCloudConnectorToGroupWithChan invokes the cc5g.AddWirelessCloudConnectorToGroup API asynchronously
func (client *Client) AddWirelessCloudConnectorToGroupWithChan(request *AddWirelessCloudConnectorToGroupRequest) (<-chan *AddWirelessCloudConnectorToGroupResponse, <-chan error) {
	responseChan := make(chan *AddWirelessCloudConnectorToGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddWirelessCloudConnectorToGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddWirelessCloudConnectorToGroupWithCallback invokes the cc5g.AddWirelessCloudConnectorToGroup API asynchronously
func (client *Client) AddWirelessCloudConnectorToGroupWithCallback(request *AddWirelessCloudConnectorToGroupRequest, callback func(response *AddWirelessCloudConnectorToGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddWirelessCloudConnectorToGroupResponse
		var err error
		defer close(result)
		response, err = client.AddWirelessCloudConnectorToGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddWirelessCloudConnectorToGroupRequest is the request struct for api AddWirelessCloudConnectorToGroup
type AddWirelessCloudConnectorToGroupRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorIds     *[]string        `position:"Query" name:"WirelessCloudConnectorIds"  type:"Repeated"`
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	DryRun                        requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
}

// AddWirelessCloudConnectorToGroupResponse is the response struct for api AddWirelessCloudConnectorToGroup
type AddWirelessCloudConnectorToGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddWirelessCloudConnectorToGroupRequest creates a request to invoke AddWirelessCloudConnectorToGroup API
func CreateAddWirelessCloudConnectorToGroupRequest() (request *AddWirelessCloudConnectorToGroupRequest) {
	request = &AddWirelessCloudConnectorToGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "AddWirelessCloudConnectorToGroup", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddWirelessCloudConnectorToGroupResponse creates a response to parse from AddWirelessCloudConnectorToGroup response
func CreateAddWirelessCloudConnectorToGroupResponse() (response *AddWirelessCloudConnectorToGroupResponse) {
	response = &AddWirelessCloudConnectorToGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
