package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWirelessCloudConnectorGroups invokes the cc5g.ListWirelessCloudConnectorGroups API synchronously
func (client *Client) ListWirelessCloudConnectorGroups(request *ListWirelessCloudConnectorGroupsRequest) (response *ListWirelessCloudConnectorGroupsResponse, err error) {
	response = CreateListWirelessCloudConnectorGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListWirelessCloudConnectorGroupsWithChan invokes the cc5g.ListWirelessCloudConnectorGroups API asynchronously
func (client *Client) ListWirelessCloudConnectorGroupsWithChan(request *ListWirelessCloudConnectorGroupsRequest) (<-chan *ListWirelessCloudConnectorGroupsResponse, <-chan error) {
	responseChan := make(chan *ListWirelessCloudConnectorGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWirelessCloudConnectorGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWirelessCloudConnectorGroupsWithCallback invokes the cc5g.ListWirelessCloudConnectorGroups API asynchronously
func (client *Client) ListWirelessCloudConnectorGroupsWithCallback(request *ListWirelessCloudConnectorGroupsRequest, callback func(response *ListWirelessCloudConnectorGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWirelessCloudConnectorGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListWirelessCloudConnectorGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWirelessCloudConnectorGroupsRequest is the request struct for api ListWirelessCloudConnectorGroups
type ListWirelessCloudConnectorGroupsRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorGroupStatus *[]string        `position:"Query" name:"WirelessCloudConnectorGroupStatus"  type:"Repeated"`
	WirelessCloudConnectorGroupIds    *[]string        `position:"Query" name:"WirelessCloudConnectorGroupIds"  type:"Repeated"`
	NextToken                         string           `position:"Query" name:"NextToken"`
	WirelessCloudConnectorGroupNames  *[]string        `position:"Query" name:"WirelessCloudConnectorGroupNames"  type:"Repeated"`
	MaxResults                        requests.Integer `position:"Query" name:"MaxResults"`
}

// ListWirelessCloudConnectorGroupsResponse is the response struct for api ListWirelessCloudConnectorGroups
type ListWirelessCloudConnectorGroupsResponse struct {
	*responses.BaseResponse
	RequestId                    string                        `json:"RequestId" xml:"RequestId"`
	NextToken                    string                        `json:"NextToken" xml:"NextToken"`
	MaxResults                   string                        `json:"MaxResults" xml:"MaxResults"`
	TotalCount                   string                        `json:"TotalCount" xml:"TotalCount"`
	WirelessCloudConnectorGroups []WirelessCloudConnectorGroup `json:"WirelessCloudConnectorGroups" xml:"WirelessCloudConnectorGroups"`
}

// CreateListWirelessCloudConnectorGroupsRequest creates a request to invoke ListWirelessCloudConnectorGroups API
func CreateListWirelessCloudConnectorGroupsRequest() (request *ListWirelessCloudConnectorGroupsRequest) {
	request = &ListWirelessCloudConnectorGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListWirelessCloudConnectorGroups", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListWirelessCloudConnectorGroupsResponse creates a response to parse from ListWirelessCloudConnectorGroups response
func CreateListWirelessCloudConnectorGroupsResponse() (response *ListWirelessCloudConnectorGroupsResponse) {
	response = &ListWirelessCloudConnectorGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
