package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListWirelessCloudConnectors invokes the cc5g.ListWirelessCloudConnectors API synchronously
func (client *Client) ListWirelessCloudConnectors(request *ListWirelessCloudConnectorsRequest) (response *ListWirelessCloudConnectorsResponse, err error) {
	response = CreateListWirelessCloudConnectorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListWirelessCloudConnectorsWithChan invokes the cc5g.ListWirelessCloudConnectors API asynchronously
func (client *Client) ListWirelessCloudConnectorsWithChan(request *ListWirelessCloudConnectorsRequest) (<-chan *ListWirelessCloudConnectorsResponse, <-chan error) {
	responseChan := make(chan *ListWirelessCloudConnectorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListWirelessCloudConnectors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListWirelessCloudConnectorsWithCallback invokes the cc5g.ListWirelessCloudConnectors API asynchronously
func (client *Client) ListWirelessCloudConnectorsWithCallback(request *ListWirelessCloudConnectorsRequest, callback func(response *ListWirelessCloudConnectorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListWirelessCloudConnectorsResponse
		var err error
		defer close(result)
		response, err = client.ListWirelessCloudConnectors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListWirelessCloudConnectorsRequest is the request struct for api ListWirelessCloudConnectors
type ListWirelessCloudConnectorsRequest struct {
	*requests.RpcRequest
	WirelessCloudConnectorGroupId string           `position:"Query" name:"WirelessCloudConnectorGroupId"`
	BusinessType                  string           `position:"Query" name:"BusinessType"`
	NextToken                     string           `position:"Query" name:"NextToken"`
	WirelessCloudConnectorIds     *[]string        `position:"Query" name:"WirelessCloudConnectorIds"  type:"Repeated"`
	IsInGroup                     string           `position:"Query" name:"IsInGroup"`
	Names                         *[]string        `position:"Query" name:"Names"  type:"Repeated"`
	MaxResults                    requests.Integer `position:"Query" name:"MaxResults"`
	Statuses                      *[]string        `position:"Query" name:"Statuses"  type:"Repeated"`
}

// ListWirelessCloudConnectorsResponse is the response struct for api ListWirelessCloudConnectors
type ListWirelessCloudConnectorsResponse struct {
	*responses.BaseResponse
	RequestId               string                   `json:"RequestId" xml:"RequestId"`
	NextToken               string                   `json:"NextToken" xml:"NextToken"`
	MaxResults              string                   `json:"MaxResults" xml:"MaxResults"`
	TotalCount              string                   `json:"TotalCount" xml:"TotalCount"`
	WirelessCloudConnectors []WirelessCloudConnector `json:"WirelessCloudConnectors" xml:"WirelessCloudConnectors"`
}

// CreateListWirelessCloudConnectorsRequest creates a request to invoke ListWirelessCloudConnectors API
func CreateListWirelessCloudConnectorsRequest() (request *ListWirelessCloudConnectorsRequest) {
	request = &ListWirelessCloudConnectorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "ListWirelessCloudConnectors", "fivegcc", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListWirelessCloudConnectorsResponse creates a response to parse from ListWirelessCloudConnectors response
func CreateListWirelessCloudConnectorsResponse() (response *ListWirelessCloudConnectorsResponse) {
	response = &ListWirelessCloudConnectorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
