package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddCases invokes the ccc.AddCases API synchronously
func (client *Client) AddCases(request *AddCasesRequest) (response *AddCasesResponse, err error) {
	response = CreateAddCasesResponse()
	err = client.DoAction(request, response)
	return
}

// AddCasesWithChan invokes the ccc.AddCases API asynchronously
func (client *Client) AddCasesWithChan(request *AddCasesRequest) (<-chan *AddCasesResponse, <-chan error) {
	responseChan := make(chan *AddCasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddCases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddCasesWithCallback invokes the ccc.AddCases API asynchronously
func (client *Client) AddCasesWithCallback(request *AddCasesRequest, callback func(response *AddCasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddCasesResponse
		var err error
		defer close(result)
		response, err = client.AddCases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddCasesRequest is the request struct for api AddCases
type AddCasesRequest struct {
	*requests.RpcRequest
	InstanceId string              `position:"Query" name:"InstanceId"`
	CampaignId string              `position:"Query" name:"CampaignId"`
	CaseList   *[]AddCasesCaseList `position:"Query" name:"CaseList"  type:"Json"`
}

// AddCasesCaseList is a repeated param struct in AddCasesRequest
type AddCasesCaseList struct {
	CustomVariables string `name:"CustomVariables"`
	Caller          string `name:"Caller"`
	PhoneNumber     string `name:"PhoneNumber"`
	MaskedCallee    string `name:"MaskedCallee"`
	ReferenceId     string `name:"ReferenceId"`
}

// AddCasesResponse is the response struct for api AddCases
type AddCasesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateAddCasesRequest creates a request to invoke AddCases API
func CreateAddCasesRequest() (request *AddCasesRequest) {
	request = &AddCasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "AddCases", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddCasesResponse creates a response to parse from AddCases response
func CreateAddCasesResponse() (response *AddCasesResponse) {
	response = &AddCasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
