package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEarlyMediaRecording invokes the ccc.GetEarlyMediaRecording API synchronously
func (client *Client) GetEarlyMediaRecording(request *GetEarlyMediaRecordingRequest) (response *GetEarlyMediaRecordingResponse, err error) {
	response = CreateGetEarlyMediaRecordingResponse()
	err = client.DoAction(request, response)
	return
}

// GetEarlyMediaRecordingWithChan invokes the ccc.GetEarlyMediaRecording API asynchronously
func (client *Client) GetEarlyMediaRecordingWithChan(request *GetEarlyMediaRecordingRequest) (<-chan *GetEarlyMediaRecordingResponse, <-chan error) {
	responseChan := make(chan *GetEarlyMediaRecordingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEarlyMediaRecording(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEarlyMediaRecordingWithCallback invokes the ccc.GetEarlyMediaRecording API asynchronously
func (client *Client) GetEarlyMediaRecordingWithCallback(request *GetEarlyMediaRecordingRequest, callback func(response *GetEarlyMediaRecordingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEarlyMediaRecordingResponse
		var err error
		defer close(result)
		response, err = client.GetEarlyMediaRecording(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEarlyMediaRecordingRequest is the request struct for api GetEarlyMediaRecording
type GetEarlyMediaRecordingRequest struct {
	*requests.RpcRequest
	ContactId  string `position:"Query" name:"ContactId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetEarlyMediaRecordingResponse is the response struct for api GetEarlyMediaRecording
type GetEarlyMediaRecordingResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetEarlyMediaRecordingRequest creates a request to invoke GetEarlyMediaRecording API
func CreateGetEarlyMediaRecordingRequest() (request *GetEarlyMediaRecordingRequest) {
	request = &GetEarlyMediaRecordingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetEarlyMediaRecording", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEarlyMediaRecordingResponse creates a response to parse from GetEarlyMediaRecording response
func CreateGetEarlyMediaRecordingResponse() (response *GetEarlyMediaRecordingResponse) {
	response = &GetEarlyMediaRecordingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
