package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeviceGenderStatistics invokes the cdrs.ListDeviceGenderStatistics API synchronously
func (client *Client) ListDeviceGenderStatistics(request *ListDeviceGenderStatisticsRequest) (response *ListDeviceGenderStatisticsResponse, err error) {
	response = CreateListDeviceGenderStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeviceGenderStatisticsWithChan invokes the cdrs.ListDeviceGenderStatistics API asynchronously
func (client *Client) ListDeviceGenderStatisticsWithChan(request *ListDeviceGenderStatisticsRequest) (<-chan *ListDeviceGenderStatisticsResponse, <-chan error) {
	responseChan := make(chan *ListDeviceGenderStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeviceGenderStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeviceGenderStatisticsWithCallback invokes the cdrs.ListDeviceGenderStatistics API asynchronously
func (client *Client) ListDeviceGenderStatisticsWithCallback(request *ListDeviceGenderStatisticsRequest, callback func(response *ListDeviceGenderStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeviceGenderStatisticsResponse
		var err error
		defer close(result)
		response, err = client.ListDeviceGenderStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeviceGenderStatisticsRequest is the request struct for api ListDeviceGenderStatistics
type ListDeviceGenderStatisticsRequest struct {
	*requests.RpcRequest
	CorpId       string `position:"Body" name:"CorpId"`
	EndTime      string `position:"Body" name:"EndTime"`
	StartTime    string `position:"Body" name:"StartTime"`
	DataSourceId string `position:"Body" name:"DataSourceId"`
}

// ListDeviceGenderStatisticsResponse is the response struct for api ListDeviceGenderStatistics
type ListDeviceGenderStatisticsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListDeviceGenderStatisticsRequest creates a request to invoke ListDeviceGenderStatistics API
func CreateListDeviceGenderStatisticsRequest() (request *ListDeviceGenderStatisticsRequest) {
	request = &ListDeviceGenderStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListDeviceGenderStatistics", "", "")
	request.Method = requests.POST
	return
}

// CreateListDeviceGenderStatisticsResponse creates a response to parse from ListDeviceGenderStatistics response
func CreateListDeviceGenderStatisticsResponse() (response *ListDeviceGenderStatisticsResponse) {
	response = &ListDeviceGenderStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
