package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteBindAccount invokes the cloud_siem.DeleteBindAccount API synchronously
func (client *Client) DeleteBindAccount(request *DeleteBindAccountRequest) (response *DeleteBindAccountResponse, err error) {
	response = CreateDeleteBindAccountResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteBindAccountWithChan invokes the cloud_siem.DeleteBindAccount API asynchronously
func (client *Client) DeleteBindAccountWithChan(request *DeleteBindAccountRequest) (<-chan *DeleteBindAccountResponse, <-chan error) {
	responseChan := make(chan *DeleteBindAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteBindAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteBindAccountWithCallback invokes the cloud_siem.DeleteBindAccount API asynchronously
func (client *Client) DeleteBindAccountWithCallback(request *DeleteBindAccountRequest, callback func(response *DeleteBindAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteBindAccountResponse
		var err error
		defer close(result)
		response, err = client.DeleteBindAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteBindAccountRequest is the request struct for api DeleteBindAccount
type DeleteBindAccountRequest struct {
	*requests.RpcRequest
	CloudCode string           `position:"Body" name:"CloudCode"`
	AccountId string           `position:"Body" name:"AccountId"`
	BindId    requests.Integer `position:"Body" name:"BindId"`
	AccessId  string           `position:"Body" name:"AccessId"`
}

// DeleteBindAccountResponse is the response struct for api DeleteBindAccount
type DeleteBindAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteBindAccountRequest creates a request to invoke DeleteBindAccount API
func CreateDeleteBindAccountRequest() (request *DeleteBindAccountRequest) {
	request = &DeleteBindAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DeleteBindAccount", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteBindAccountResponse creates a response to parse from DeleteBindAccount response
func CreateDeleteBindAccountResponse() (response *DeleteBindAccountResponse) {
	response = &DeleteBindAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
