package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCloudSiemEvents invokes the cloud_siem.DescribeCloudSiemEvents API synchronously
func (client *Client) DescribeCloudSiemEvents(request *DescribeCloudSiemEventsRequest) (response *DescribeCloudSiemEventsResponse, err error) {
	response = CreateDescribeCloudSiemEventsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCloudSiemEventsWithChan invokes the cloud_siem.DescribeCloudSiemEvents API asynchronously
func (client *Client) DescribeCloudSiemEventsWithChan(request *DescribeCloudSiemEventsRequest) (<-chan *DescribeCloudSiemEventsResponse, <-chan error) {
	responseChan := make(chan *DescribeCloudSiemEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCloudSiemEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCloudSiemEventsWithCallback invokes the cloud_siem.DescribeCloudSiemEvents API asynchronously
func (client *Client) DescribeCloudSiemEventsWithCallback(request *DescribeCloudSiemEventsRequest, callback func(response *DescribeCloudSiemEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCloudSiemEventsResponse
		var err error
		defer close(result)
		response, err = client.DescribeCloudSiemEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCloudSiemEventsRequest is the request struct for api DescribeCloudSiemEvents
type DescribeCloudSiemEventsRequest struct {
	*requests.RpcRequest
	StartTime    requests.Integer `position:"Body" name:"StartTime"`
	EventName    string           `position:"Body" name:"EventName"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	OrderField   string           `position:"Body" name:"OrderField"`
	Order        string           `position:"Body" name:"Order"`
	EndTime      requests.Integer `position:"Body" name:"EndTime"`
	CurrentPage  requests.Integer `position:"Body" name:"CurrentPage"`
	ThreadLevel  *[]string        `position:"Body" name:"ThreadLevel"  type:"Repeated"`
	AssetId      string           `position:"Body" name:"AssetId"`
	IncidentUuid string           `position:"Body" name:"IncidentUuid"`
	Status       requests.Integer `position:"Body" name:"Status"`
}

// DescribeCloudSiemEventsResponse is the response struct for api DescribeCloudSiemEvents
type DescribeCloudSiemEventsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCloudSiemEventsRequest creates a request to invoke DescribeCloudSiemEvents API
func CreateDescribeCloudSiemEventsRequest() (request *DescribeCloudSiemEventsRequest) {
	request = &DescribeCloudSiemEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeCloudSiemEvents", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCloudSiemEventsResponse creates a response to parse from DescribeCloudSiemEvents response
func CreateDescribeCloudSiemEventsResponse() (response *DescribeCloudSiemEventsResponse) {
	response = &DescribeCloudSiemEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
