package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCustomizeRule invokes the cloud_siem.DescribeCustomizeRule API synchronously
func (client *Client) DescribeCustomizeRule(request *DescribeCustomizeRuleRequest) (response *DescribeCustomizeRuleResponse, err error) {
	response = CreateDescribeCustomizeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCustomizeRuleWithChan invokes the cloud_siem.DescribeCustomizeRule API asynchronously
func (client *Client) DescribeCustomizeRuleWithChan(request *DescribeCustomizeRuleRequest) (<-chan *DescribeCustomizeRuleResponse, <-chan error) {
	responseChan := make(chan *DescribeCustomizeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCustomizeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCustomizeRuleWithCallback invokes the cloud_siem.DescribeCustomizeRule API asynchronously
func (client *Client) DescribeCustomizeRuleWithCallback(request *DescribeCustomizeRuleRequest, callback func(response *DescribeCustomizeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCustomizeRuleResponse
		var err error
		defer close(result)
		response, err = client.DescribeCustomizeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCustomizeRuleRequest is the request struct for api DescribeCustomizeRule
type DescribeCustomizeRuleRequest struct {
	*requests.RpcRequest
	RuleId requests.Integer `position:"Body" name:"RuleId"`
}

// DescribeCustomizeRuleResponse is the response struct for api DescribeCustomizeRule
type DescribeCustomizeRuleResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeCustomizeRuleRequest creates a request to invoke DescribeCustomizeRule API
func CreateDescribeCustomizeRuleRequest() (request *DescribeCustomizeRuleRequest) {
	request = &DescribeCustomizeRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeCustomizeRule", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCustomizeRuleResponse creates a response to parse from DescribeCustomizeRule response
func CreateDescribeCustomizeRuleResponse() (response *DescribeCustomizeRuleResponse) {
	response = &DescribeCustomizeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
