package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Mobile3MetaDetailStandardVerify invokes the cloudauth.Mobile3MetaDetailStandardVerify API synchronously
func (client *Client) Mobile3MetaDetailStandardVerify(request *Mobile3MetaDetailStandardVerifyRequest) (response *Mobile3MetaDetailStandardVerifyResponse, err error) {
	response = CreateMobile3MetaDetailStandardVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// Mobile3MetaDetailStandardVerifyWithChan invokes the cloudauth.Mobile3MetaDetailStandardVerify API asynchronously
func (client *Client) Mobile3MetaDetailStandardVerifyWithChan(request *Mobile3MetaDetailStandardVerifyRequest) (<-chan *Mobile3MetaDetailStandardVerifyResponse, <-chan error) {
	responseChan := make(chan *Mobile3MetaDetailStandardVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Mobile3MetaDetailStandardVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Mobile3MetaDetailStandardVerifyWithCallback invokes the cloudauth.Mobile3MetaDetailStandardVerify API asynchronously
func (client *Client) Mobile3MetaDetailStandardVerifyWithCallback(request *Mobile3MetaDetailStandardVerifyRequest, callback func(response *Mobile3MetaDetailStandardVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Mobile3MetaDetailStandardVerifyResponse
		var err error
		defer close(result)
		response, err = client.Mobile3MetaDetailStandardVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Mobile3MetaDetailStandardVerifyRequest is the request struct for api Mobile3MetaDetailStandardVerify
type Mobile3MetaDetailStandardVerifyRequest struct {
	*requests.RpcRequest
	ParamType   string `position:"Body" name:"ParamType"`
	Mobile      string `position:"Body" name:"Mobile"`
	IdentifyNum string `position:"Body" name:"IdentifyNum"`
	UserName    string `position:"Body" name:"UserName"`
}

// Mobile3MetaDetailStandardVerifyResponse is the response struct for api Mobile3MetaDetailStandardVerify
type Mobile3MetaDetailStandardVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateMobile3MetaDetailStandardVerifyRequest creates a request to invoke Mobile3MetaDetailStandardVerify API
func CreateMobile3MetaDetailStandardVerifyRequest() (request *Mobile3MetaDetailStandardVerifyRequest) {
	request = &Mobile3MetaDetailStandardVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Mobile3MetaDetailStandardVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMobile3MetaDetailStandardVerifyResponse creates a response to parse from Mobile3MetaDetailStandardVerify response
func CreateMobile3MetaDetailStandardVerifyResponse() (response *Mobile3MetaDetailStandardVerifyResponse) {
	response = &Mobile3MetaDetailStandardVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
