package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Vehicle5ItemQuery invokes the cloudauth.Vehicle5ItemQuery API synchronously
func (client *Client) Vehicle5ItemQuery(request *Vehicle5ItemQueryRequest) (response *Vehicle5ItemQueryResponse, err error) {
	response = CreateVehicle5ItemQueryResponse()
	err = client.DoAction(request, response)
	return
}

// Vehicle5ItemQueryWithChan invokes the cloudauth.Vehicle5ItemQuery API asynchronously
func (client *Client) Vehicle5ItemQueryWithChan(request *Vehicle5ItemQueryRequest) (<-chan *Vehicle5ItemQueryResponse, <-chan error) {
	responseChan := make(chan *Vehicle5ItemQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Vehicle5ItemQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Vehicle5ItemQueryWithCallback invokes the cloudauth.Vehicle5ItemQuery API asynchronously
func (client *Client) Vehicle5ItemQueryWithCallback(request *Vehicle5ItemQueryRequest, callback func(response *Vehicle5ItemQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Vehicle5ItemQueryResponse
		var err error
		defer close(result)
		response, err = client.Vehicle5ItemQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Vehicle5ItemQueryRequest is the request struct for api Vehicle5ItemQuery
type Vehicle5ItemQueryRequest struct {
	*requests.RpcRequest
	VehicleType string `position:"Query" name:"VehicleType"`
	ParamType   string `position:"Query" name:"ParamType"`
	VehicleNum  string `position:"Query" name:"VehicleNum"`
}

// Vehicle5ItemQueryResponse is the response struct for api Vehicle5ItemQuery
type Vehicle5ItemQueryResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Message      string       `json:"Message" xml:"Message"`
	Code         string       `json:"Code" xml:"Code"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateVehicle5ItemQueryRequest creates a request to invoke Vehicle5ItemQuery API
func CreateVehicle5ItemQueryRequest() (request *Vehicle5ItemQueryRequest) {
	request = &Vehicle5ItemQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Vehicle5ItemQuery", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVehicle5ItemQueryResponse creates a response to parse from Vehicle5ItemQuery response
func CreateVehicle5ItemQueryResponse() (response *Vehicle5ItemQueryResponse) {
	response = &Vehicle5ItemQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
