package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFunctionMeta invokes the cloudcallcenter.DeleteFunctionMeta API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletefunctionmeta.html
func (client *Client) DeleteFunctionMeta(request *DeleteFunctionMetaRequest) (response *DeleteFunctionMetaResponse, err error) {
	response = CreateDeleteFunctionMetaResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFunctionMetaWithChan invokes the cloudcallcenter.DeleteFunctionMeta API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletefunctionmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFunctionMetaWithChan(request *DeleteFunctionMetaRequest) (<-chan *DeleteFunctionMetaResponse, <-chan error) {
	responseChan := make(chan *DeleteFunctionMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFunctionMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFunctionMetaWithCallback invokes the cloudcallcenter.DeleteFunctionMeta API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/deletefunctionmeta.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteFunctionMetaWithCallback(request *DeleteFunctionMetaRequest, callback func(response *DeleteFunctionMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFunctionMetaResponse
		var err error
		defer close(result)
		response, err = client.DeleteFunctionMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFunctionMetaRequest is the request struct for api DeleteFunctionMeta
type DeleteFunctionMetaRequest struct {
	*requests.RpcRequest
	FunctionId string `position:"Query" name:"FunctionId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DeleteFunctionMetaResponse is the response struct for api DeleteFunctionMeta
type DeleteFunctionMetaResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateDeleteFunctionMetaRequest creates a request to invoke DeleteFunctionMeta API
func CreateDeleteFunctionMetaRequest() (request *DeleteFunctionMetaRequest) {
	request = &DeleteFunctionMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DeleteFunctionMeta", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteFunctionMetaResponse creates a response to parse from DeleteFunctionMeta response
func CreateDeleteFunctionMetaResponse() (response *DeleteFunctionMetaResponse) {
	response = &DeleteFunctionMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
