package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCompanyTemplatePictureNew invokes the cloudesl.GetCompanyTemplatePictureNew API synchronously
func (client *Client) GetCompanyTemplatePictureNew(request *GetCompanyTemplatePictureNewRequest) (response *GetCompanyTemplatePictureNewResponse, err error) {
	response = CreateGetCompanyTemplatePictureNewResponse()
	err = client.DoAction(request, response)
	return
}

// GetCompanyTemplatePictureNewWithChan invokes the cloudesl.GetCompanyTemplatePictureNew API asynchronously
func (client *Client) GetCompanyTemplatePictureNewWithChan(request *GetCompanyTemplatePictureNewRequest) (<-chan *GetCompanyTemplatePictureNewResponse, <-chan error) {
	responseChan := make(chan *GetCompanyTemplatePictureNewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCompanyTemplatePictureNew(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCompanyTemplatePictureNewWithCallback invokes the cloudesl.GetCompanyTemplatePictureNew API asynchronously
func (client *Client) GetCompanyTemplatePictureNewWithCallback(request *GetCompanyTemplatePictureNewRequest, callback func(response *GetCompanyTemplatePictureNewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCompanyTemplatePictureNewResponse
		var err error
		defer close(result)
		response, err = client.GetCompanyTemplatePictureNew(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCompanyTemplatePictureNewRequest is the request struct for api GetCompanyTemplatePictureNew
type GetCompanyTemplatePictureNewRequest struct {
	*requests.RpcRequest
	Data string `position:"Body" name:"Data"`
}

// GetCompanyTemplatePictureNewResponse is the response struct for api GetCompanyTemplatePictureNew
type GetCompanyTemplatePictureNewResponse struct {
	*responses.BaseResponse
	Base64Picture  string `json:"Base64Picture" xml:"Base64Picture"`
	JobId          string `json:"JobId" xml:"JobId"`
	Type           string `json:"Type" xml:"Type"`
	Url            string `json:"Url" xml:"Url"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Message        string `json:"Message" xml:"Message"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code           string `json:"Code" xml:"Code"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
}

// CreateGetCompanyTemplatePictureNewRequest creates a request to invoke GetCompanyTemplatePictureNew API
func CreateGetCompanyTemplatePictureNewRequest() (request *GetCompanyTemplatePictureNewRequest) {
	request = &GetCompanyTemplatePictureNewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "GetCompanyTemplatePictureNew", "", "")
	request.Method = requests.POST
	return
}

// CreateGetCompanyTemplatePictureNewResponse creates a response to parse from GetCompanyTemplatePictureNew response
func CreateGetCompanyTemplatePictureNewResponse() (response *GetCompanyTemplatePictureNewResponse) {
	response = &GetCompanyTemplatePictureNewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
