package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDefaultIPSConfig invokes the cloudfw.DescribeDefaultIPSConfig API synchronously
func (client *Client) DescribeDefaultIPSConfig(request *DescribeDefaultIPSConfigRequest) (response *DescribeDefaultIPSConfigResponse, err error) {
	response = CreateDescribeDefaultIPSConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDefaultIPSConfigWithChan invokes the cloudfw.DescribeDefaultIPSConfig API asynchronously
func (client *Client) DescribeDefaultIPSConfigWithChan(request *DescribeDefaultIPSConfigRequest) (<-chan *DescribeDefaultIPSConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDefaultIPSConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDefaultIPSConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDefaultIPSConfigWithCallback invokes the cloudfw.DescribeDefaultIPSConfig API asynchronously
func (client *Client) DescribeDefaultIPSConfigWithCallback(request *DescribeDefaultIPSConfigRequest, callback func(response *DescribeDefaultIPSConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDefaultIPSConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDefaultIPSConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDefaultIPSConfigRequest is the request struct for api DescribeDefaultIPSConfig
type DescribeDefaultIPSConfigRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeDefaultIPSConfigResponse is the response struct for api DescribeDefaultIPSConfig
type DescribeDefaultIPSConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	RuleClass      int    `json:"RuleClass" xml:"RuleClass"`
	EnableAllPatch int    `json:"EnableAllPatch" xml:"EnableAllPatch"`
	CtiRules       int    `json:"CtiRules" xml:"CtiRules"`
	EnableDefault  int    `json:"EnableDefault" xml:"EnableDefault"`
	PatchRules     int    `json:"PatchRules" xml:"PatchRules"`
	RunMode        int    `json:"RunMode" xml:"RunMode"`
	BasicRules     int    `json:"BasicRules" xml:"BasicRules"`
	AiRules        int    `json:"AiRules" xml:"AiRules"`
}

// CreateDescribeDefaultIPSConfigRequest creates a request to invoke DescribeDefaultIPSConfig API
func CreateDescribeDefaultIPSConfigRequest() (request *DescribeDefaultIPSConfigRequest) {
	request = &DescribeDefaultIPSConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeDefaultIPSConfig", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDefaultIPSConfigResponse creates a response to parse from DescribeDefaultIPSConfig response
func CreateDescribeDefaultIPSConfigResponse() (response *DescribeDefaultIPSConfigResponse) {
	response = &DescribeDefaultIPSConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
