package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcFirewallControlPolicy invokes the cloudfw.DescribeVpcFirewallControlPolicy API synchronously
func (client *Client) DescribeVpcFirewallControlPolicy(request *DescribeVpcFirewallControlPolicyRequest) (response *DescribeVpcFirewallControlPolicyResponse, err error) {
	response = CreateDescribeVpcFirewallControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcFirewallControlPolicyWithChan invokes the cloudfw.DescribeVpcFirewallControlPolicy API asynchronously
func (client *Client) DescribeVpcFirewallControlPolicyWithChan(request *DescribeVpcFirewallControlPolicyRequest) (<-chan *DescribeVpcFirewallControlPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcFirewallControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcFirewallControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcFirewallControlPolicyWithCallback invokes the cloudfw.DescribeVpcFirewallControlPolicy API asynchronously
func (client *Client) DescribeVpcFirewallControlPolicyWithCallback(request *DescribeVpcFirewallControlPolicyRequest, callback func(response *DescribeVpcFirewallControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcFirewallControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcFirewallControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcFirewallControlPolicyRequest is the request struct for api DescribeVpcFirewallControlPolicy
type DescribeVpcFirewallControlPolicyRequest struct {
	*requests.RpcRequest
	Release       string `position:"Query" name:"Release"`
	Destination   string `position:"Query" name:"Destination"`
	Description   string `position:"Query" name:"Description"`
	Source        string `position:"Query" name:"Source"`
	AclUuid       string `position:"Query" name:"AclUuid"`
	AclAction     string `position:"Query" name:"AclAction"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	PageSize      string `position:"Query" name:"PageSize"`
	Lang          string `position:"Query" name:"Lang"`
	VpcFirewallId string `position:"Query" name:"VpcFirewallId"`
	CurrentPage   string `position:"Query" name:"CurrentPage"`
	MemberUid     string `position:"Query" name:"MemberUid"`
	Proto         string `position:"Query" name:"Proto"`
}

// DescribeVpcFirewallControlPolicyResponse is the response struct for api DescribeVpcFirewallControlPolicy
type DescribeVpcFirewallControlPolicyResponse struct {
	*responses.BaseResponse
	TotalCount string     `json:"TotalCount" xml:"TotalCount"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Policys    []DataItem `json:"Policys" xml:"Policys"`
}

// CreateDescribeVpcFirewallControlPolicyRequest creates a request to invoke DescribeVpcFirewallControlPolicy API
func CreateDescribeVpcFirewallControlPolicyRequest() (request *DescribeVpcFirewallControlPolicyRequest) {
	request = &DescribeVpcFirewallControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeVpcFirewallControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcFirewallControlPolicyResponse creates a response to parse from DescribeVpcFirewallControlPolicy response
func CreateDescribeVpcFirewallControlPolicyResponse() (response *DescribeVpcFirewallControlPolicyResponse) {
	response = &DescribeVpcFirewallControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
