package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenCmsService invokes the cms.OpenCmsService API synchronously
func (client *Client) OpenCmsService(request *OpenCmsServiceRequest) (response *OpenCmsServiceResponse, err error) {
	response = CreateOpenCmsServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenCmsServiceWithChan invokes the cms.OpenCmsService API asynchronously
func (client *Client) OpenCmsServiceWithChan(request *OpenCmsServiceRequest) (<-chan *OpenCmsServiceResponse, <-chan error) {
	responseChan := make(chan *OpenCmsServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenCmsService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenCmsServiceWithCallback invokes the cms.OpenCmsService API asynchronously
func (client *Client) OpenCmsServiceWithCallback(request *OpenCmsServiceRequest, callback func(response *OpenCmsServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenCmsServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenCmsService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenCmsServiceRequest is the request struct for api OpenCmsService
type OpenCmsServiceRequest struct {
	*requests.RpcRequest
}

// OpenCmsServiceResponse is the response struct for api OpenCmsService
type OpenCmsServiceResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenCmsServiceRequest creates a request to invoke OpenCmsService API
func CreateOpenCmsServiceRequest() (request *OpenCmsServiceRequest) {
	request = &OpenCmsServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "OpenCmsService", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenCmsServiceResponse creates a response to parse from OpenCmsService response
func CreateOpenCmsServiceResponse() (response *OpenCmsServiceResponse) {
	response = &OpenCmsServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
