package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UninstallMonitoringAgent invokes the cms.UninstallMonitoringAgent API synchronously
func (client *Client) UninstallMonitoringAgent(request *UninstallMonitoringAgentRequest) (response *UninstallMonitoringAgentResponse, err error) {
	response = CreateUninstallMonitoringAgentResponse()
	err = client.DoAction(request, response)
	return
}

// UninstallMonitoringAgentWithChan invokes the cms.UninstallMonitoringAgent API asynchronously
func (client *Client) UninstallMonitoringAgentWithChan(request *UninstallMonitoringAgentRequest) (<-chan *UninstallMonitoringAgentResponse, <-chan error) {
	responseChan := make(chan *UninstallMonitoringAgentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UninstallMonitoringAgent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UninstallMonitoringAgentWithCallback invokes the cms.UninstallMonitoringAgent API asynchronously
func (client *Client) UninstallMonitoringAgentWithCallback(request *UninstallMonitoringAgentRequest, callback func(response *UninstallMonitoringAgentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UninstallMonitoringAgentResponse
		var err error
		defer close(result)
		response, err = client.UninstallMonitoringAgent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UninstallMonitoringAgentRequest is the request struct for api UninstallMonitoringAgent
type UninstallMonitoringAgentRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// UninstallMonitoringAgentResponse is the response struct for api UninstallMonitoringAgent
type UninstallMonitoringAgentResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUninstallMonitoringAgentRequest creates a request to invoke UninstallMonitoringAgent API
func CreateUninstallMonitoringAgentRequest() (request *UninstallMonitoringAgentRequest) {
	request = &UninstallMonitoringAgentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "UninstallMonitoringAgent", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUninstallMonitoringAgentResponse creates a response to parse from UninstallMonitoringAgent response
func CreateUninstallMonitoringAgentResponse() (response *UninstallMonitoringAgentResponse) {
	response = &UninstallMonitoringAgentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
