package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddRepositoryMember invokes the codeup.AddRepositoryMember API synchronously
func (client *Client) AddRepositoryMember(request *AddRepositoryMemberRequest) (response *AddRepositoryMemberResponse, err error) {
	response = CreateAddRepositoryMemberResponse()
	err = client.DoAction(request, response)
	return
}

// AddRepositoryMemberWithChan invokes the codeup.AddRepositoryMember API asynchronously
func (client *Client) AddRepositoryMemberWithChan(request *AddRepositoryMemberRequest) (<-chan *AddRepositoryMemberResponse, <-chan error) {
	responseChan := make(chan *AddRepositoryMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddRepositoryMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddRepositoryMemberWithCallback invokes the codeup.AddRepositoryMember API asynchronously
func (client *Client) AddRepositoryMemberWithCallback(request *AddRepositoryMemberRequest, callback func(response *AddRepositoryMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddRepositoryMemberResponse
		var err error
		defer close(result)
		response, err = client.AddRepositoryMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddRepositoryMemberRequest is the request struct for api AddRepositoryMember
type AddRepositoryMemberRequest struct {
	*requests.RoaRequest
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	SubUserId      string           `position:"Query" name:"SubUserId"`
	ClientToken    string           `position:"Query" name:"ClientToken"`
	AccessToken    string           `position:"Query" name:"AccessToken"`
	ProjectId      requests.Integer `position:"Path" name:"ProjectId"`
}

// AddRepositoryMemberResponse is the response struct for api AddRepositoryMember
type AddRepositoryMemberResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	Success      bool         `json:"Success" xml:"Success"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateAddRepositoryMemberRequest creates a request to invoke AddRepositoryMember API
func CreateAddRepositoryMemberRequest() (request *AddRepositoryMemberRequest) {
	request = &AddRepositoryMemberRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "AddRepositoryMember", "/api/v4/projects/[ProjectId]/members", "", "")
	request.Method = requests.POST
	return
}

// CreateAddRepositoryMemberResponse creates a response to parse from AddRepositoryMember response
func CreateAddRepositoryMemberResponse() (response *AddRepositoryMemberResponse) {
	response = &AddRepositoryMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
