package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSupportedResourceRelationConfig invokes the config.GetSupportedResourceRelationConfig API synchronously
func (client *Client) GetSupportedResourceRelationConfig(request *GetSupportedResourceRelationConfigRequest) (response *GetSupportedResourceRelationConfigResponse, err error) {
	response = CreateGetSupportedResourceRelationConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetSupportedResourceRelationConfigWithChan invokes the config.GetSupportedResourceRelationConfig API asynchronously
func (client *Client) GetSupportedResourceRelationConfigWithChan(request *GetSupportedResourceRelationConfigRequest) (<-chan *GetSupportedResourceRelationConfigResponse, <-chan error) {
	responseChan := make(chan *GetSupportedResourceRelationConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSupportedResourceRelationConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSupportedResourceRelationConfigWithCallback invokes the config.GetSupportedResourceRelationConfig API asynchronously
func (client *Client) GetSupportedResourceRelationConfigWithCallback(request *GetSupportedResourceRelationConfigRequest, callback func(response *GetSupportedResourceRelationConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSupportedResourceRelationConfigResponse
		var err error
		defer close(result)
		response, err = client.GetSupportedResourceRelationConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSupportedResourceRelationConfigRequest is the request struct for api GetSupportedResourceRelationConfig
type GetSupportedResourceRelationConfigRequest struct {
	*requests.RpcRequest
	ResourceType string `position:"Query" name:"ResourceType"`
}

// GetSupportedResourceRelationConfigResponse is the response struct for api GetSupportedResourceRelationConfig
type GetSupportedResourceRelationConfigResponse struct {
	*responses.BaseResponse
	RequestId                  string                           `json:"RequestId" xml:"RequestId"`
	ResourceRelationConfigList []ResourceRelationConfigListItem `json:"ResourceRelationConfigList" xml:"ResourceRelationConfigList"`
}

// CreateGetSupportedResourceRelationConfigRequest creates a request to invoke GetSupportedResourceRelationConfig API
func CreateGetSupportedResourceRelationConfigRequest() (request *GetSupportedResourceRelationConfigRequest) {
	request = &GetSupportedResourceRelationConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetSupportedResourceRelationConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSupportedResourceRelationConfigResponse creates a response to parse from GetSupportedResourceRelationConfig response
func CreateGetSupportedResourceRelationConfigResponse() (response *GetSupportedResourceRelationConfigResponse) {
	response = &GetSupportedResourceRelationConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
