package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivateAccessPolices invokes the csas.ListPrivateAccessPolices API synchronously
func (client *Client) ListPrivateAccessPolices(request *ListPrivateAccessPolicesRequest) (response *ListPrivateAccessPolicesResponse, err error) {
	response = CreateListPrivateAccessPolicesResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivateAccessPolicesWithChan invokes the csas.ListPrivateAccessPolices API asynchronously
func (client *Client) ListPrivateAccessPolicesWithChan(request *ListPrivateAccessPolicesRequest) (<-chan *ListPrivateAccessPolicesResponse, <-chan error) {
	responseChan := make(chan *ListPrivateAccessPolicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivateAccessPolices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivateAccessPolicesWithCallback invokes the csas.ListPrivateAccessPolices API asynchronously
func (client *Client) ListPrivateAccessPolicesWithCallback(request *ListPrivateAccessPolicesRequest, callback func(response *ListPrivateAccessPolicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivateAccessPolicesResponse
		var err error
		defer close(result)
		response, err = client.ListPrivateAccessPolices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivateAccessPolicesRequest is the request struct for api ListPrivateAccessPolices
type ListPrivateAccessPolicesRequest struct {
	*requests.RpcRequest
	PolicyIds       *[]string        `position:"Query" name:"PolicyIds"  type:"Repeated"`
	TagName         string           `position:"Query" name:"TagName"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ApplicationId   string           `position:"Query" name:"ApplicationId"`
	TagId           string           `position:"Query" name:"TagId"`
	UserGroupId     string           `position:"Query" name:"UserGroupId"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	PolicyAction    string           `position:"Query" name:"PolicyAction"`
	ApplicationName string           `position:"Query" name:"ApplicationName"`
	Name            string           `position:"Query" name:"Name"`
	Status          string           `position:"Query" name:"Status"`
}

// ListPrivateAccessPolicesResponse is the response struct for api ListPrivateAccessPolices
type ListPrivateAccessPolicesResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	TotalNum  int                                `json:"TotalNum" xml:"TotalNum"`
	Polices   []PolicyInListPrivateAccessPolices `json:"Polices" xml:"Polices"`
}

// CreateListPrivateAccessPolicesRequest creates a request to invoke ListPrivateAccessPolices API
func CreateListPrivateAccessPolicesRequest() (request *ListPrivateAccessPolicesRequest) {
	request = &ListPrivateAccessPolicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListPrivateAccessPolices", "", "")
	request.Method = requests.GET
	return
}

// CreateListPrivateAccessPolicesResponse creates a response to parse from ListPrivateAccessPolices response
func CreateListPrivateAccessPolicesResponse() (response *ListPrivateAccessPolicesResponse) {
	response = &ListPrivateAccessPolicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
