package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMetaCategory invokes the dataworks_public.CreateMetaCategory API synchronously
func (client *Client) CreateMetaCategory(request *CreateMetaCategoryRequest) (response *CreateMetaCategoryResponse, err error) {
	response = CreateCreateMetaCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMetaCategoryWithChan invokes the dataworks_public.CreateMetaCategory API asynchronously
func (client *Client) CreateMetaCategoryWithChan(request *CreateMetaCategoryRequest) (<-chan *CreateMetaCategoryResponse, <-chan error) {
	responseChan := make(chan *CreateMetaCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMetaCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMetaCategoryWithCallback invokes the dataworks_public.CreateMetaCategory API asynchronously
func (client *Client) CreateMetaCategoryWithCallback(request *CreateMetaCategoryRequest, callback func(response *CreateMetaCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMetaCategoryResponse
		var err error
		defer close(result)
		response, err = client.CreateMetaCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMetaCategoryRequest is the request struct for api CreateMetaCategory
type CreateMetaCategoryRequest struct {
	*requests.RpcRequest
	ParentId requests.Integer `position:"Body" name:"ParentId"`
	Name     string           `position:"Body" name:"Name"`
	Comment  string           `position:"Body" name:"Comment"`
}

// CreateMetaCategoryResponse is the response struct for api CreateMetaCategory
type CreateMetaCategoryResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCreateMetaCategoryRequest creates a request to invoke CreateMetaCategory API
func CreateCreateMetaCategoryRequest() (request *CreateMetaCategoryRequest) {
	request = &CreateMetaCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateMetaCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMetaCategoryResponse creates a response to parse from CreateMetaCategory response
func CreateCreateMetaCategoryResponse() (response *CreateMetaCategoryResponse) {
	response = &CreateMetaCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
