package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgPlatformQueryProjectsAndSchemaFromMeta invokes the dataworks_public.DsgPlatformQueryProjectsAndSchemaFromMeta API synchronously
func (client *Client) DsgPlatformQueryProjectsAndSchemaFromMeta(request *DsgPlatformQueryProjectsAndSchemaFromMetaRequest) (response *DsgPlatformQueryProjectsAndSchemaFromMetaResponse, err error) {
	response = CreateDsgPlatformQueryProjectsAndSchemaFromMetaResponse()
	err = client.DoAction(request, response)
	return
}

// DsgPlatformQueryProjectsAndSchemaFromMetaWithChan invokes the dataworks_public.DsgPlatformQueryProjectsAndSchemaFromMeta API asynchronously
func (client *Client) DsgPlatformQueryProjectsAndSchemaFromMetaWithChan(request *DsgPlatformQueryProjectsAndSchemaFromMetaRequest) (<-chan *DsgPlatformQueryProjectsAndSchemaFromMetaResponse, <-chan error) {
	responseChan := make(chan *DsgPlatformQueryProjectsAndSchemaFromMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgPlatformQueryProjectsAndSchemaFromMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgPlatformQueryProjectsAndSchemaFromMetaWithCallback invokes the dataworks_public.DsgPlatformQueryProjectsAndSchemaFromMeta API asynchronously
func (client *Client) DsgPlatformQueryProjectsAndSchemaFromMetaWithCallback(request *DsgPlatformQueryProjectsAndSchemaFromMetaRequest, callback func(response *DsgPlatformQueryProjectsAndSchemaFromMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgPlatformQueryProjectsAndSchemaFromMetaResponse
		var err error
		defer close(result)
		response, err = client.DsgPlatformQueryProjectsAndSchemaFromMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgPlatformQueryProjectsAndSchemaFromMetaRequest is the request struct for api DsgPlatformQueryProjectsAndSchemaFromMeta
type DsgPlatformQueryProjectsAndSchemaFromMetaRequest struct {
	*requests.RpcRequest
	EngineName string `position:"Query" name:"EngineName"`
}

// DsgPlatformQueryProjectsAndSchemaFromMetaResponse is the response struct for api DsgPlatformQueryProjectsAndSchemaFromMeta
type DsgPlatformQueryProjectsAndSchemaFromMetaResponse struct {
	*responses.BaseResponse
	Success        bool    `json:"Success" xml:"Success"`
	ErrorCode      string  `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string  `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Data           []Datas `json:"Data" xml:"Data"`
}

// CreateDsgPlatformQueryProjectsAndSchemaFromMetaRequest creates a request to invoke DsgPlatformQueryProjectsAndSchemaFromMeta API
func CreateDsgPlatformQueryProjectsAndSchemaFromMetaRequest() (request *DsgPlatformQueryProjectsAndSchemaFromMetaRequest) {
	request = &DsgPlatformQueryProjectsAndSchemaFromMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgPlatformQueryProjectsAndSchemaFromMeta", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgPlatformQueryProjectsAndSchemaFromMetaResponse creates a response to parse from DsgPlatformQueryProjectsAndSchemaFromMeta response
func CreateDsgPlatformQueryProjectsAndSchemaFromMetaResponse() (response *DsgPlatformQueryProjectsAndSchemaFromMetaResponse) {
	response = &DsgPlatformQueryProjectsAndSchemaFromMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
