package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgUserGroupQueryUserList invokes the dataworks_public.DsgUserGroupQueryUserList API synchronously
func (client *Client) DsgUserGroupQueryUserList(request *DsgUserGroupQueryUserListRequest) (response *DsgUserGroupQueryUserListResponse, err error) {
	response = CreateDsgUserGroupQueryUserListResponse()
	err = client.DoAction(request, response)
	return
}

// DsgUserGroupQueryUserListWithChan invokes the dataworks_public.DsgUserGroupQueryUserList API asynchronously
func (client *Client) DsgUserGroupQueryUserListWithChan(request *DsgUserGroupQueryUserListRequest) (<-chan *DsgUserGroupQueryUserListResponse, <-chan error) {
	responseChan := make(chan *DsgUserGroupQueryUserListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgUserGroupQueryUserList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgUserGroupQueryUserListWithCallback invokes the dataworks_public.DsgUserGroupQueryUserList API asynchronously
func (client *Client) DsgUserGroupQueryUserListWithCallback(request *DsgUserGroupQueryUserListRequest, callback func(response *DsgUserGroupQueryUserListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgUserGroupQueryUserListResponse
		var err error
		defer close(result)
		response, err = client.DsgUserGroupQueryUserList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgUserGroupQueryUserListRequest is the request struct for api DsgUserGroupQueryUserList
type DsgUserGroupQueryUserListRequest struct {
	*requests.RpcRequest
}

// DsgUserGroupQueryUserListResponse is the response struct for api DsgUserGroupQueryUserList
type DsgUserGroupQueryUserListResponse struct {
	*responses.BaseResponse
	Success        bool    `json:"Success" xml:"Success"`
	ErrorCode      string  `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string  `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Data           []Datas `json:"Data" xml:"Data"`
}

// CreateDsgUserGroupQueryUserListRequest creates a request to invoke DsgUserGroupQueryUserList API
func CreateDsgUserGroupQueryUserListRequest() (request *DsgUserGroupQueryUserListRequest) {
	request = &DsgUserGroupQueryUserListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgUserGroupQueryUserList", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgUserGroupQueryUserListResponse creates a response to parse from DsgUserGroupQueryUserList response
func CreateDsgUserGroupQueryUserListResponse() (response *DsgUserGroupQueryUserListResponse) {
	response = &DsgUserGroupQueryUserListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
