package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateDISyncTaskConfigForUpdating invokes the dataworks_public.GenerateDISyncTaskConfigForUpdating API synchronously
func (client *Client) GenerateDISyncTaskConfigForUpdating(request *GenerateDISyncTaskConfigForUpdatingRequest) (response *GenerateDISyncTaskConfigForUpdatingResponse, err error) {
	response = CreateGenerateDISyncTaskConfigForUpdatingResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateDISyncTaskConfigForUpdatingWithChan invokes the dataworks_public.GenerateDISyncTaskConfigForUpdating API asynchronously
func (client *Client) GenerateDISyncTaskConfigForUpdatingWithChan(request *GenerateDISyncTaskConfigForUpdatingRequest) (<-chan *GenerateDISyncTaskConfigForUpdatingResponse, <-chan error) {
	responseChan := make(chan *GenerateDISyncTaskConfigForUpdatingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateDISyncTaskConfigForUpdating(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateDISyncTaskConfigForUpdatingWithCallback invokes the dataworks_public.GenerateDISyncTaskConfigForUpdating API asynchronously
func (client *Client) GenerateDISyncTaskConfigForUpdatingWithCallback(request *GenerateDISyncTaskConfigForUpdatingRequest, callback func(response *GenerateDISyncTaskConfigForUpdatingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateDISyncTaskConfigForUpdatingResponse
		var err error
		defer close(result)
		response, err = client.GenerateDISyncTaskConfigForUpdating(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateDISyncTaskConfigForUpdatingRequest is the request struct for api GenerateDISyncTaskConfigForUpdating
type GenerateDISyncTaskConfigForUpdatingRequest struct {
	*requests.RpcRequest
	TaskType    string           `position:"Query" name:"TaskType"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	TaskParam   string           `position:"Query" name:"TaskParam"`
	ProjectId   requests.Integer `position:"Query" name:"ProjectId"`
	TaskId      requests.Integer `position:"Query" name:"TaskId"`
}

// GenerateDISyncTaskConfigForUpdatingResponse is the response struct for api GenerateDISyncTaskConfigForUpdating
type GenerateDISyncTaskConfigForUpdatingResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateDISyncTaskConfigForUpdatingRequest creates a request to invoke GenerateDISyncTaskConfigForUpdating API
func CreateGenerateDISyncTaskConfigForUpdatingRequest() (request *GenerateDISyncTaskConfigForUpdatingRequest) {
	request = &GenerateDISyncTaskConfigForUpdatingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GenerateDISyncTaskConfigForUpdating", "", "")
	request.Method = requests.POST
	return
}

// CreateGenerateDISyncTaskConfigForUpdatingResponse creates a response to parse from GenerateDISyncTaskConfigForUpdating response
func CreateGenerateDISyncTaskConfigForUpdatingResponse() (response *GenerateDISyncTaskConfigForUpdatingResponse) {
	response = &GenerateDISyncTaskConfigForUpdatingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
