package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetaTableBasicInfo invokes the dataworks_public.GetMetaTableBasicInfo API synchronously
func (client *Client) GetMetaTableBasicInfo(request *GetMetaTableBasicInfoRequest) (response *GetMetaTableBasicInfoResponse, err error) {
	response = CreateGetMetaTableBasicInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetaTableBasicInfoWithChan invokes the dataworks_public.GetMetaTableBasicInfo API asynchronously
func (client *Client) GetMetaTableBasicInfoWithChan(request *GetMetaTableBasicInfoRequest) (<-chan *GetMetaTableBasicInfoResponse, <-chan error) {
	responseChan := make(chan *GetMetaTableBasicInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetaTableBasicInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetaTableBasicInfoWithCallback invokes the dataworks_public.GetMetaTableBasicInfo API asynchronously
func (client *Client) GetMetaTableBasicInfoWithCallback(request *GetMetaTableBasicInfoRequest, callback func(response *GetMetaTableBasicInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetaTableBasicInfoResponse
		var err error
		defer close(result)
		response, err = client.GetMetaTableBasicInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetaTableBasicInfoRequest is the request struct for api GetMetaTableBasicInfo
type GetMetaTableBasicInfoRequest struct {
	*requests.RpcRequest
	DataSourceType string           `position:"Query" name:"DataSourceType"`
	Extension      requests.Boolean `position:"Query" name:"Extension"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	TableGuid      string           `position:"Query" name:"TableGuid"`
	DatabaseName   string           `position:"Query" name:"DatabaseName"`
	TableName      string           `position:"Query" name:"TableName"`
}

// GetMetaTableBasicInfoResponse is the response struct for api GetMetaTableBasicInfo
type GetMetaTableBasicInfoResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetMetaTableBasicInfoRequest creates a request to invoke GetMetaTableBasicInfo API
func CreateGetMetaTableBasicInfoRequest() (request *GetMetaTableBasicInfoRequest) {
	request = &GetMetaTableBasicInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetMetaTableBasicInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetMetaTableBasicInfoResponse creates a response to parse from GetMetaTableBasicInfo response
func CreateGetMetaTableBasicInfoResponse() (response *GetMetaTableBasicInfoResponse) {
	response = &GetMetaTableBasicInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
