package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopDIJob invokes the dataworks_public.StopDIJob API synchronously
func (client *Client) StopDIJob(request *StopDIJobRequest) (response *StopDIJobResponse, err error) {
	response = CreateStopDIJobResponse()
	err = client.DoAction(request, response)
	return
}

// StopDIJobWithChan invokes the dataworks_public.StopDIJob API asynchronously
func (client *Client) StopDIJobWithChan(request *StopDIJobRequest) (<-chan *StopDIJobResponse, <-chan error) {
	responseChan := make(chan *StopDIJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopDIJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopDIJobWithCallback invokes the dataworks_public.StopDIJob API asynchronously
func (client *Client) StopDIJobWithCallback(request *StopDIJobRequest, callback func(response *StopDIJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopDIJobResponse
		var err error
		defer close(result)
		response, err = client.StopDIJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopDIJobRequest is the request struct for api StopDIJob
type StopDIJobRequest struct {
	*requests.RpcRequest
	DIJobId requests.Integer `position:"Body" name:"DIJobId"`
}

// StopDIJobResponse is the response struct for api StopDIJob
type StopDIJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopDIJobRequest creates a request to invoke StopDIJob API
func CreateStopDIJobRequest() (request *StopDIJobRequest) {
	request = &StopDIJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "StopDIJob", "", "")
	request.Method = requests.POST
	return
}

// CreateStopDIJobResponse creates a response to parse from StopDIJob response
func CreateStopDIJobResponse() (response *StopDIJobResponse) {
	response = &StopDIJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
