package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDcdnWafPolicy invokes the dcdn.CreateDcdnWafPolicy API synchronously
func (client *Client) CreateDcdnWafPolicy(request *CreateDcdnWafPolicyRequest) (response *CreateDcdnWafPolicyResponse, err error) {
	response = CreateCreateDcdnWafPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDcdnWafPolicyWithChan invokes the dcdn.CreateDcdnWafPolicy API asynchronously
func (client *Client) CreateDcdnWafPolicyWithChan(request *CreateDcdnWafPolicyRequest) (<-chan *CreateDcdnWafPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateDcdnWafPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDcdnWafPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDcdnWafPolicyWithCallback invokes the dcdn.CreateDcdnWafPolicy API asynchronously
func (client *Client) CreateDcdnWafPolicyWithCallback(request *CreateDcdnWafPolicyRequest, callback func(response *CreateDcdnWafPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDcdnWafPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateDcdnWafPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDcdnWafPolicyRequest is the request struct for api CreateDcdnWafPolicy
type CreateDcdnWafPolicyRequest struct {
	*requests.RpcRequest
	DefenseScene string `position:"Body" name:"DefenseScene"`
	PolicyType   string `position:"Body" name:"PolicyType"`
	PolicyStatus string `position:"Body" name:"PolicyStatus"`
	PolicyName   string `position:"Body" name:"PolicyName"`
}

// CreateDcdnWafPolicyResponse is the response struct for api CreateDcdnWafPolicy
type CreateDcdnWafPolicyResponse struct {
	*responses.BaseResponse
	PolicyId  int64  `json:"PolicyId" xml:"PolicyId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateDcdnWafPolicyRequest creates a request to invoke CreateDcdnWafPolicy API
func CreateCreateDcdnWafPolicyRequest() (request *CreateDcdnWafPolicyRequest) {
	request = &CreateDcdnWafPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "CreateDcdnWafPolicy", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDcdnWafPolicyResponse creates a response to parse from CreateDcdnWafPolicy response
func CreateCreateDcdnWafPolicyResponse() (response *CreateDcdnWafPolicyResponse) {
	response = &CreateDcdnWafPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
