package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnKvAccountStatus invokes the dcdn.DescribeDcdnKvAccountStatus API synchronously
func (client *Client) DescribeDcdnKvAccountStatus(request *DescribeDcdnKvAccountStatusRequest) (response *DescribeDcdnKvAccountStatusResponse, err error) {
	response = CreateDescribeDcdnKvAccountStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnKvAccountStatusWithChan invokes the dcdn.DescribeDcdnKvAccountStatus API asynchronously
func (client *Client) DescribeDcdnKvAccountStatusWithChan(request *DescribeDcdnKvAccountStatusRequest) (<-chan *DescribeDcdnKvAccountStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnKvAccountStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnKvAccountStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnKvAccountStatusWithCallback invokes the dcdn.DescribeDcdnKvAccountStatus API asynchronously
func (client *Client) DescribeDcdnKvAccountStatusWithCallback(request *DescribeDcdnKvAccountStatusRequest, callback func(response *DescribeDcdnKvAccountStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnKvAccountStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnKvAccountStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnKvAccountStatusRequest is the request struct for api DescribeDcdnKvAccountStatus
type DescribeDcdnKvAccountStatusRequest struct {
	*requests.RpcRequest
}

// DescribeDcdnKvAccountStatusResponse is the response struct for api DescribeDcdnKvAccountStatus
type DescribeDcdnKvAccountStatusResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeDcdnKvAccountStatusRequest creates a request to invoke DescribeDcdnKvAccountStatus API
func CreateDescribeDcdnKvAccountStatusRequest() (request *DescribeDcdnKvAccountStatusRequest) {
	request = &DescribeDcdnKvAccountStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnKvAccountStatus", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnKvAccountStatusResponse creates a response to parse from DescribeDcdnKvAccountStatus response
func CreateDescribeDcdnKvAccountStatusResponse() (response *DescribeDcdnKvAccountStatusResponse) {
	response = &DescribeDcdnKvAccountStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
