package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishDcdnStagingConfigToProduction invokes the dcdn.PublishDcdnStagingConfigToProduction API synchronously
func (client *Client) PublishDcdnStagingConfigToProduction(request *PublishDcdnStagingConfigToProductionRequest) (response *PublishDcdnStagingConfigToProductionResponse, err error) {
	response = CreatePublishDcdnStagingConfigToProductionResponse()
	err = client.DoAction(request, response)
	return
}

// PublishDcdnStagingConfigToProductionWithChan invokes the dcdn.PublishDcdnStagingConfigToProduction API asynchronously
func (client *Client) PublishDcdnStagingConfigToProductionWithChan(request *PublishDcdnStagingConfigToProductionRequest) (<-chan *PublishDcdnStagingConfigToProductionResponse, <-chan error) {
	responseChan := make(chan *PublishDcdnStagingConfigToProductionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishDcdnStagingConfigToProduction(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishDcdnStagingConfigToProductionWithCallback invokes the dcdn.PublishDcdnStagingConfigToProduction API asynchronously
func (client *Client) PublishDcdnStagingConfigToProductionWithCallback(request *PublishDcdnStagingConfigToProductionRequest, callback func(response *PublishDcdnStagingConfigToProductionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishDcdnStagingConfigToProductionResponse
		var err error
		defer close(result)
		response, err = client.PublishDcdnStagingConfigToProduction(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishDcdnStagingConfigToProductionRequest is the request struct for api PublishDcdnStagingConfigToProduction
type PublishDcdnStagingConfigToProductionRequest struct {
	*requests.RpcRequest
	FunctionName string `position:"Query" name:"FunctionName"`
	DomainName   string `position:"Query" name:"DomainName"`
}

// PublishDcdnStagingConfigToProductionResponse is the response struct for api PublishDcdnStagingConfigToProduction
type PublishDcdnStagingConfigToProductionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePublishDcdnStagingConfigToProductionRequest creates a request to invoke PublishDcdnStagingConfigToProduction API
func CreatePublishDcdnStagingConfigToProductionRequest() (request *PublishDcdnStagingConfigToProductionRequest) {
	request = &PublishDcdnStagingConfigToProductionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "PublishDcdnStagingConfigToProduction", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishDcdnStagingConfigToProductionResponse creates a response to parse from PublishDcdnStagingConfigToProduction response
func CreatePublishDcdnStagingConfigToProductionResponse() (response *PublishDcdnStagingConfigToProductionResponse) {
	response = &PublishDcdnStagingConfigToProductionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
