package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableSceneDefensePolicy invokes the ddoscoo.EnableSceneDefensePolicy API synchronously
func (client *Client) EnableSceneDefensePolicy(request *EnableSceneDefensePolicyRequest) (response *EnableSceneDefensePolicyResponse, err error) {
	response = CreateEnableSceneDefensePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// EnableSceneDefensePolicyWithChan invokes the ddoscoo.EnableSceneDefensePolicy API asynchronously
func (client *Client) EnableSceneDefensePolicyWithChan(request *EnableSceneDefensePolicyRequest) (<-chan *EnableSceneDefensePolicyResponse, <-chan error) {
	responseChan := make(chan *EnableSceneDefensePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableSceneDefensePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableSceneDefensePolicyWithCallback invokes the ddoscoo.EnableSceneDefensePolicy API asynchronously
func (client *Client) EnableSceneDefensePolicyWithCallback(request *EnableSceneDefensePolicyRequest, callback func(response *EnableSceneDefensePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableSceneDefensePolicyResponse
		var err error
		defer close(result)
		response, err = client.EnableSceneDefensePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableSceneDefensePolicyRequest is the request struct for api EnableSceneDefensePolicy
type EnableSceneDefensePolicyRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	PolicyId string `position:"Query" name:"PolicyId"`
}

// EnableSceneDefensePolicyResponse is the response struct for api EnableSceneDefensePolicy
type EnableSceneDefensePolicyResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableSceneDefensePolicyRequest creates a request to invoke EnableSceneDefensePolicy API
func CreateEnableSceneDefensePolicyRequest() (request *EnableSceneDefensePolicyRequest) {
	request = &EnableSceneDefensePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "EnableSceneDefensePolicy", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableSceneDefensePolicyResponse creates a response to parse from EnableSceneDefensePolicy response
func CreateEnableSceneDefensePolicyResponse() (response *EnableSceneDefensePolicyResponse) {
	response = &EnableSceneDefensePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
