package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDomainResource invokes the ddoscoo.ModifyDomainResource API synchronously
func (client *Client) ModifyDomainResource(request *ModifyDomainResourceRequest) (response *ModifyDomainResourceResponse, err error) {
	response = CreateModifyDomainResourceResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDomainResourceWithChan invokes the ddoscoo.ModifyDomainResource API asynchronously
func (client *Client) ModifyDomainResourceWithChan(request *ModifyDomainResourceRequest) (<-chan *ModifyDomainResourceResponse, <-chan error) {
	responseChan := make(chan *ModifyDomainResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDomainResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDomainResourceWithCallback invokes the ddoscoo.ModifyDomainResource API asynchronously
func (client *Client) ModifyDomainResourceWithCallback(request *ModifyDomainResourceRequest, callback func(response *ModifyDomainResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDomainResourceResponse
		var err error
		defer close(result)
		response, err = client.ModifyDomainResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDomainResourceRequest is the request struct for api ModifyDomainResource
type ModifyDomainResourceRequest struct {
	*requests.RpcRequest
	HttpsExt    string                            `position:"Query" name:"HttpsExt"`
	SourceIp    string                            `position:"Query" name:"SourceIp"`
	RsType      requests.Integer                  `position:"Query" name:"RsType"`
	RealServers *[]string                         `position:"Query" name:"RealServers"  type:"Repeated"`
	InstanceIds *[]string                         `position:"Query" name:"InstanceIds"  type:"Repeated"`
	ProxyTypes  *[]ModifyDomainResourceProxyTypes `position:"Query" name:"ProxyTypes"  type:"Repeated"`
	Domain      string                            `position:"Query" name:"Domain"`
}

// ModifyDomainResourceProxyTypes is a repeated param struct in ModifyDomainResourceRequest
type ModifyDomainResourceProxyTypes struct {
	ProxyPorts *[]string `name:"ProxyPorts" type:"Repeated"`
	ProxyType  string    `name:"ProxyType"`
}

// ModifyDomainResourceResponse is the response struct for api ModifyDomainResource
type ModifyDomainResourceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDomainResourceRequest creates a request to invoke ModifyDomainResource API
func CreateModifyDomainResourceRequest() (request *ModifyDomainResourceRequest) {
	request = &ModifyDomainResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyDomainResource", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDomainResourceResponse creates a response to parse from ModifyDomainResource response
func CreateModifyDomainResourceResponse() (response *ModifyDomainResourceResponse) {
	response = &ModifyDomainResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
