package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyElasticBizBandWidth invokes the ddoscoo.ModifyElasticBizBandWidth API synchronously
func (client *Client) ModifyElasticBizBandWidth(request *ModifyElasticBizBandWidthRequest) (response *ModifyElasticBizBandWidthResponse, err error) {
	response = CreateModifyElasticBizBandWidthResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyElasticBizBandWidthWithChan invokes the ddoscoo.ModifyElasticBizBandWidth API asynchronously
func (client *Client) ModifyElasticBizBandWidthWithChan(request *ModifyElasticBizBandWidthRequest) (<-chan *ModifyElasticBizBandWidthResponse, <-chan error) {
	responseChan := make(chan *ModifyElasticBizBandWidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyElasticBizBandWidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyElasticBizBandWidthWithCallback invokes the ddoscoo.ModifyElasticBizBandWidth API asynchronously
func (client *Client) ModifyElasticBizBandWidthWithCallback(request *ModifyElasticBizBandWidthRequest, callback func(response *ModifyElasticBizBandWidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyElasticBizBandWidthResponse
		var err error
		defer close(result)
		response, err = client.ModifyElasticBizBandWidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyElasticBizBandWidthRequest is the request struct for api ModifyElasticBizBandWidth
type ModifyElasticBizBandWidthRequest struct {
	*requests.RpcRequest
	ElasticBizBandwidth requests.Integer `position:"Query" name:"ElasticBizBandwidth"`
	Mode                string           `position:"Query" name:"Mode"`
	SourceIp            string           `position:"Query" name:"SourceIp"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
}

// ModifyElasticBizBandWidthResponse is the response struct for api ModifyElasticBizBandWidth
type ModifyElasticBizBandWidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyElasticBizBandWidthRequest creates a request to invoke ModifyElasticBizBandWidth API
func CreateModifyElasticBizBandWidthRequest() (request *ModifyElasticBizBandWidthRequest) {
	request = &ModifyElasticBizBandWidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyElasticBizBandWidth", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyElasticBizBandWidthResponse creates a response to parse from ModifyElasticBizBandWidth response
func CreateModifyElasticBizBandWidthResponse() (response *ModifyElasticBizBandWidthResponse) {
	response = &ModifyElasticBizBandWidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
