package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyFullLogTtl invokes the ddoscoo.ModifyFullLogTtl API synchronously
func (client *Client) ModifyFullLogTtl(request *ModifyFullLogTtlRequest) (response *ModifyFullLogTtlResponse, err error) {
	response = CreateModifyFullLogTtlResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyFullLogTtlWithChan invokes the ddoscoo.ModifyFullLogTtl API asynchronously
func (client *Client) ModifyFullLogTtlWithChan(request *ModifyFullLogTtlRequest) (<-chan *ModifyFullLogTtlResponse, <-chan error) {
	responseChan := make(chan *ModifyFullLogTtlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyFullLogTtl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyFullLogTtlWithCallback invokes the ddoscoo.ModifyFullLogTtl API asynchronously
func (client *Client) ModifyFullLogTtlWithCallback(request *ModifyFullLogTtlRequest, callback func(response *ModifyFullLogTtlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyFullLogTtlResponse
		var err error
		defer close(result)
		response, err = client.ModifyFullLogTtl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyFullLogTtlRequest is the request struct for api ModifyFullLogTtl
type ModifyFullLogTtlRequest struct {
	*requests.RpcRequest
	Ttl             requests.Integer `position:"Query" name:"Ttl"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
}

// ModifyFullLogTtlResponse is the response struct for api ModifyFullLogTtl
type ModifyFullLogTtlResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyFullLogTtlRequest creates a request to invoke ModifyFullLogTtl API
func CreateModifyFullLogTtlRequest() (request *ModifyFullLogTtlRequest) {
	request = &ModifyFullLogTtlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyFullLogTtl", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyFullLogTtlResponse creates a response to parse from ModifyFullLogTtl response
func CreateModifyFullLogTtlResponse() (response *ModifyFullLogTtlResponse) {
	response = &ModifyFullLogTtlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
