package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyWebAIProtectSwitch invokes the ddoscoo.ModifyWebAIProtectSwitch API synchronously
func (client *Client) ModifyWebAIProtectSwitch(request *ModifyWebAIProtectSwitchRequest) (response *ModifyWebAIProtectSwitchResponse, err error) {
	response = CreateModifyWebAIProtectSwitchResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyWebAIProtectSwitchWithChan invokes the ddoscoo.ModifyWebAIProtectSwitch API asynchronously
func (client *Client) ModifyWebAIProtectSwitchWithChan(request *ModifyWebAIProtectSwitchRequest) (<-chan *ModifyWebAIProtectSwitchResponse, <-chan error) {
	responseChan := make(chan *ModifyWebAIProtectSwitchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyWebAIProtectSwitch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyWebAIProtectSwitchWithCallback invokes the ddoscoo.ModifyWebAIProtectSwitch API asynchronously
func (client *Client) ModifyWebAIProtectSwitchWithCallback(request *ModifyWebAIProtectSwitchRequest, callback func(response *ModifyWebAIProtectSwitchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyWebAIProtectSwitchResponse
		var err error
		defer close(result)
		response, err = client.ModifyWebAIProtectSwitch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyWebAIProtectSwitchRequest is the request struct for api ModifyWebAIProtectSwitch
type ModifyWebAIProtectSwitchRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
	Config          string `position:"Query" name:"Config"`
}

// ModifyWebAIProtectSwitchResponse is the response struct for api ModifyWebAIProtectSwitch
type ModifyWebAIProtectSwitchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyWebAIProtectSwitchRequest creates a request to invoke ModifyWebAIProtectSwitch API
func CreateModifyWebAIProtectSwitchRequest() (request *ModifyWebAIProtectSwitchRequest) {
	request = &ModifyWebAIProtectSwitchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyWebAIProtectSwitch", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyWebAIProtectSwitchResponse creates a response to parse from ModifyWebAIProtectSwitch response
func CreateModifyWebAIProtectSwitchResponse() (response *ModifyWebAIProtectSwitchResponse) {
	response = &ModifyWebAIProtectSwitchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
