package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAbacAuthorization invokes the dms_enterprise.DeleteAbacAuthorization API synchronously
func (client *Client) DeleteAbacAuthorization(request *DeleteAbacAuthorizationRequest) (response *DeleteAbacAuthorizationResponse, err error) {
	response = CreateDeleteAbacAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAbacAuthorizationWithChan invokes the dms_enterprise.DeleteAbacAuthorization API asynchronously
func (client *Client) DeleteAbacAuthorizationWithChan(request *DeleteAbacAuthorizationRequest) (<-chan *DeleteAbacAuthorizationResponse, <-chan error) {
	responseChan := make(chan *DeleteAbacAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAbacAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAbacAuthorizationWithCallback invokes the dms_enterprise.DeleteAbacAuthorization API asynchronously
func (client *Client) DeleteAbacAuthorizationWithCallback(request *DeleteAbacAuthorizationRequest, callback func(response *DeleteAbacAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAbacAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.DeleteAbacAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAbacAuthorizationRequest is the request struct for api DeleteAbacAuthorization
type DeleteAbacAuthorizationRequest struct {
	*requests.RpcRequest
	Tid             requests.Integer `position:"Query" name:"Tid"`
	IdentityType    string           `position:"Query" name:"IdentityType"`
	AuthorizationId requests.Integer `position:"Query" name:"AuthorizationId"`
}

// DeleteAbacAuthorizationResponse is the response struct for api DeleteAbacAuthorization
type DeleteAbacAuthorizationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Result       string `json:"Result" xml:"Result"`
}

// CreateDeleteAbacAuthorizationRequest creates a request to invoke DeleteAbacAuthorization API
func CreateDeleteAbacAuthorizationRequest() (request *DeleteAbacAuthorizationRequest) {
	request = &DeleteAbacAuthorizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteAbacAuthorization", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAbacAuthorizationResponse creates a response to parse from DeleteAbacAuthorization response
func CreateDeleteAbacAuthorizationResponse() (response *DeleteAbacAuthorizationResponse) {
	response = &DeleteAbacAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
