package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLakeHouseSpace invokes the dms_enterprise.DeleteLakeHouseSpace API synchronously
func (client *Client) DeleteLakeHouseSpace(request *DeleteLakeHouseSpaceRequest) (response *DeleteLakeHouseSpaceResponse, err error) {
	response = CreateDeleteLakeHouseSpaceResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLakeHouseSpaceWithChan invokes the dms_enterprise.DeleteLakeHouseSpace API asynchronously
func (client *Client) DeleteLakeHouseSpaceWithChan(request *DeleteLakeHouseSpaceRequest) (<-chan *DeleteLakeHouseSpaceResponse, <-chan error) {
	responseChan := make(chan *DeleteLakeHouseSpaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLakeHouseSpace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLakeHouseSpaceWithCallback invokes the dms_enterprise.DeleteLakeHouseSpace API asynchronously
func (client *Client) DeleteLakeHouseSpaceWithCallback(request *DeleteLakeHouseSpaceRequest, callback func(response *DeleteLakeHouseSpaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLakeHouseSpaceResponse
		var err error
		defer close(result)
		response, err = client.DeleteLakeHouseSpace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLakeHouseSpaceRequest is the request struct for api DeleteLakeHouseSpace
type DeleteLakeHouseSpaceRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	SpaceId requests.Integer `position:"Query" name:"SpaceId"`
}

// DeleteLakeHouseSpaceResponse is the response struct for api DeleteLakeHouseSpace
type DeleteLakeHouseSpaceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateDeleteLakeHouseSpaceRequest creates a request to invoke DeleteLakeHouseSpace API
func CreateDeleteLakeHouseSpaceRequest() (request *DeleteLakeHouseSpaceRequest) {
	request = &DeleteLakeHouseSpaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteLakeHouseSpace", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLakeHouseSpaceResponse creates a response to parse from DeleteLakeHouseSpace response
func CreateDeleteLakeHouseSpaceResponse() (response *DeleteLakeHouseSpaceResponse) {
	response = &DeleteLakeHouseSpaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
