package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataTrackJobDegree invokes the dms_enterprise.GetDataTrackJobDegree API synchronously
func (client *Client) GetDataTrackJobDegree(request *GetDataTrackJobDegreeRequest) (response *GetDataTrackJobDegreeResponse, err error) {
	response = CreateGetDataTrackJobDegreeResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataTrackJobDegreeWithChan invokes the dms_enterprise.GetDataTrackJobDegree API asynchronously
func (client *Client) GetDataTrackJobDegreeWithChan(request *GetDataTrackJobDegreeRequest) (<-chan *GetDataTrackJobDegreeResponse, <-chan error) {
	responseChan := make(chan *GetDataTrackJobDegreeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataTrackJobDegree(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataTrackJobDegreeWithCallback invokes the dms_enterprise.GetDataTrackJobDegree API asynchronously
func (client *Client) GetDataTrackJobDegreeWithCallback(request *GetDataTrackJobDegreeRequest, callback func(response *GetDataTrackJobDegreeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataTrackJobDegreeResponse
		var err error
		defer close(result)
		response, err = client.GetDataTrackJobDegree(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataTrackJobDegreeRequest is the request struct for api GetDataTrackJobDegree
type GetDataTrackJobDegreeRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetDataTrackJobDegreeResponse is the response struct for api GetDataTrackJobDegree
type GetDataTrackJobDegreeResponse struct {
	*responses.BaseResponse
	RequestId    string    `json:"RequestId" xml:"RequestId"`
	Success      bool      `json:"Success" xml:"Success"`
	ErrorMessage string    `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string    `json:"ErrorCode" xml:"ErrorCode"`
	JobDegree    JobDegree `json:"JobDegree" xml:"JobDegree"`
}

// CreateGetDataTrackJobDegreeRequest creates a request to invoke GetDataTrackJobDegree API
func CreateGetDataTrackJobDegreeRequest() (request *GetDataTrackJobDegreeRequest) {
	request = &GetDataTrackJobDegreeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataTrackJobDegree", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataTrackJobDegreeResponse creates a response to parse from GetDataTrackJobDegree response
func CreateGetDataTrackJobDegreeResponse() (response *GetDataTrackJobDegreeResponse) {
	response = &GetDataTrackJobDegreeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
