package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStructSyncExecSqlDetail invokes the dms_enterprise.GetStructSyncExecSqlDetail API synchronously
func (client *Client) GetStructSyncExecSqlDetail(request *GetStructSyncExecSqlDetailRequest) (response *GetStructSyncExecSqlDetailResponse, err error) {
	response = CreateGetStructSyncExecSqlDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetStructSyncExecSqlDetailWithChan invokes the dms_enterprise.GetStructSyncExecSqlDetail API asynchronously
func (client *Client) GetStructSyncExecSqlDetailWithChan(request *GetStructSyncExecSqlDetailRequest) (<-chan *GetStructSyncExecSqlDetailResponse, <-chan error) {
	responseChan := make(chan *GetStructSyncExecSqlDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStructSyncExecSqlDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStructSyncExecSqlDetailWithCallback invokes the dms_enterprise.GetStructSyncExecSqlDetail API asynchronously
func (client *Client) GetStructSyncExecSqlDetailWithCallback(request *GetStructSyncExecSqlDetailRequest, callback func(response *GetStructSyncExecSqlDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStructSyncExecSqlDetailResponse
		var err error
		defer close(result)
		response, err = client.GetStructSyncExecSqlDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStructSyncExecSqlDetailRequest is the request struct for api GetStructSyncExecSqlDetail
type GetStructSyncExecSqlDetailRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	OrderId    requests.Integer `position:"Query" name:"OrderId"`
}

// GetStructSyncExecSqlDetailResponse is the response struct for api GetStructSyncExecSqlDetail
type GetStructSyncExecSqlDetailResponse struct {
	*responses.BaseResponse
	RequestId               string                  `json:"RequestId" xml:"RequestId"`
	Success                 bool                    `json:"Success" xml:"Success"`
	ErrorMessage            string                  `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode               string                  `json:"ErrorCode" xml:"ErrorCode"`
	StructSyncExecSqlDetail StructSyncExecSqlDetail `json:"StructSyncExecSqlDetail" xml:"StructSyncExecSqlDetail"`
}

// CreateGetStructSyncExecSqlDetailRequest creates a request to invoke GetStructSyncExecSqlDetail API
func CreateGetStructSyncExecSqlDetailRequest() (request *GetStructSyncExecSqlDetailRequest) {
	request = &GetStructSyncExecSqlDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetStructSyncExecSqlDetail", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStructSyncExecSqlDetailResponse creates a response to parse from GetStructSyncExecSqlDetail response
func CreateGetStructSyncExecSqlDetailResponse() (response *GetStructSyncExecSqlDetailResponse) {
	response = &GetStructSyncExecSqlDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
